package cn.smarthse.radiationTraining.modules.wqxx.model.vo.integraLog;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * <p>
 * 劳动者学习档案列表 vo
 * </p>
 *
 * @author wuxq
 * @since 2023-8-30
 */
@Data
public class StaffStudyIntegralVo implements Serializable {

    private static final long serialVersionUID = 1L;

    //@ApiModelProperty("id")
    private Long userId;

    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    //@ApiModelProperty(value = "用户名")
    private String username;

    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    //@ApiModelProperty(value = "姓名")
    private String name;

    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    //@ApiModelProperty(value = "手机号")
    private String phone;

    @Desensitization(type = DesensitizationType.ID_CARD)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    //@ApiModelProperty(value = "身份证")
    private String idcard;

    //@ApiModelProperty("cid")
    private Long cid;

    //@ApiModelProperty(value = "单位名称")
    private String unitName;

    //@ApiModelProperty(value = "总积分")
    private int integralTotal;

    //@ApiModelProperty(value = "年度积分")
    private int yearIntegralTotal;

    //@ApiModelProperty(value = "公司内排名")
    private Integer unitRanking;

    //@ApiModelProperty(value = "省内排名")
    private Integer provinceRanking;

    //@ApiModelProperty(value = "挑战答题排名")
    private Integer challengeRanking;

    public String getPhone() {
        if(StringUtils.isEmpty(this.phone) && !StringUtils.isEmpty(this.username)  && this.checkPhoneNumber(this.username)){
            return this.username;
        }
        return this.phone;
    }

    public boolean checkPhoneNumber(String phoneNumber) {
        String pattern = "^(86)?1[3-9]\\d{9}$";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(phoneNumber);
        return m.matches();
    }
}
