package cn.smarthse.radiationTraining.modules.wqxx.model.vo.articleVideo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 图文视频vo
 * @author chuhy
*/
@Data
@EqualsAndHashCode(callSuper = false)
public class EarnIntegralVo implements Serializable {
    private static final long serialVersionUID = -8253936267592384548L;

    //@ApiModelProperty("")
    private Long id;
    /**
     * 用户账号id
     */
    //@ApiModelProperty("用户账号id")
    private Long userId;
    /**
     * article.id 或者 video.id
     */
    //@ApiModelProperty("article.id 或者 video.id")
    private Long businessId;
    /**
     * 积分类型(1-图文；2-视频；)
     */
    //@ApiModelProperty("积分类型(1-图文；2-视频；)")
    private Integer type;
    /**
     * 学习状态(1-未完成；2-已完成)
     */
    //@ApiModelProperty("学习状态(1-未完成；2-已完成)")
    private Integer state;
    /**
     * 学习时长/m
     */
    //@ApiModelProperty("学习时长/m")
    private Integer learnTime;
    /**
     * 学习日期
     */
    //@ApiModelProperty("学习日期")
    private Date learnDate;

    /**
     * 是否已学习完成
     */
    //@ApiModelProperty("是否已学习完成")
    private Boolean hasLearned;

    public void setHasLearned(boolean isLearned) {
        this.hasLearned = isLearned;
    }

    public void setHasLearned(Integer state) {
        if (state == null || state == 1){
            hasLearned = false;
        } else if (state == 2){
            hasLearned = true;
        }
    }
}
