package cn.smarthse.radiationTraining.modules.wqxx.model.vo.articleVideo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 图文视频vo
 * @author chuhy
*/
@Data
@EqualsAndHashCode(callSuper = false)
public class ArticleVideoVo implements Serializable {
    private static final long serialVersionUID = -7298429538309075207L;



    //@ApiModelProperty("")
    private Long id;

    /**
    * 标题
    */
    //@ApiModelProperty("标题")
    private String title;

    /**
    * 类型：1-图文；2-视频；
    */
    //@ApiModelProperty("类型：1-图文；2-视频；")
    private String type;

    /**
    * 分类
    */
    //@ApiModelProperty("分类")
    private String itype;

    /**
    * 分类
    */
    //@ApiModelProperty("分类名称")
    private String itypeName;

    /**
    * 文章内容
    */
    //@ApiModelProperty("文章内容")
    private String content;

    /**
    * 文章或视频封面图ids
    */
    //@ApiModelProperty("文章或视频封面图ids")
    private String screenshotIds;

    //@ApiModelProperty("文章或视频封面图url")
    private String screenshotUrl;

    /**
    * 附件ids
    */
    //@ApiModelProperty("附件ids")
    private String fileIds;

    //@ApiModelProperty("附件Url")
    private String fileUrl;

    /**
    * 作者或来源
    */
    //@ApiModelProperty("作者或来源")
    private String author;

    /**
     * 发布人
     */
    //@ApiModelProperty("发布人")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String releaser;

    /**
    * 发布(上架)时间
    */
    //@ApiModelProperty("发布(上架)时间")
    private Date releaseDate;

    /**
     * 点击量
     */
    //@ApiModelProperty("点击量")
    private Integer clickNums;

    /**
     * 状态：0-草稿；1-上架；2-下架；
     */
    //@ApiModelProperty("状态：0-草稿；1-上架；2-下架")
    private Integer state;

    /**
     * 学习时长/m
     */
    //@ApiModelProperty("学习时长/m")
    private Integer learnTime = 0;

    /**
     * 学习日期
     */
    //@ApiModelProperty("学习日期")
    private Date learnDate;

    /**
     * 学习状态(1-未完成；2-已完成)
     */
    //@ApiModelProperty("学习状态(1-未完成；2-已完成)")
    private Integer learnState;
}
