package cn.smarthse.radiationTraining.modules.wqxx.entity;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
* 卫企学习：用户积分流水记录
* @TableName s_user_integral_log
*/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("s_user_integral_log")
//@ApiModel(value="SUserIntegralLog对象", description="卫企学习：用户积分流水记录")
public class SUserIntegralLog implements Serializable {

    /**
    * id
    */
    //@ApiModelProperty("")
    private Long id;
    /**
     * 公司id
     */
    //@ApiModelProperty("公司id")
    private Long cid;
    /**
    * 用户账号id
    */
    //@ApiModelProperty("用户账号id")
    private Long userId;
    /**
     * 账号
     */
    //@ApiModelProperty("账号")
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String userName;
    /**
     * 手机号
     */
    //@ApiModelProperty("账号")
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String phone;
    /**
     * 姓名
     */
    //@ApiModelProperty("姓名")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String name;

    /**
    * 本次积分类型(以UserIntegralTypeEnum为准)
    */
    //@ApiModelProperty("本次积分类型(以UserIntegralTypeEnum为准)")
    private Integer type;
    /**
    * 本次积分流水
    */
    //@ApiModelProperty("本次积分流水")
    private Integer integral;
    /**
    * 积分产生的业务数据id(可能没有)
    */
    //@ApiModelProperty("积分产生的业务数据id(可能没有)")
    private Long businessId;

    /**
     * 积分获取日期
     */
    //@ApiModelProperty("积分获取日期")
    private Date obtainDate;
    /**
    * 创建时间
    */
    //@ApiModelProperty("创建时间")
    private Date createDate;
    /**
    * 最后修改时间
    */
    //@ApiModelProperty("最后修改时间")
    private Date updateDate;
    /**
    * 是否有效（0-无效，1-有效）
    */
    //@ApiModelProperty("是否有效（0-无效，1-有效）")
    private Boolean isValid;


    public SUserIntegralLog() {
    }

    public SUserIntegralLog(Long userId, Integer type, Integer integral, Long businessId) {
        this.userId = userId;
        this.type = type;
        this.integral = integral;
        this.businessId = businessId;
    }
}
