package cn.smarthse.radiationTraining.modules.training.vo.training;

import cn.smarthse.radiationTraining.modules.training.enums.TuEnrollDetailStatusEnum;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * Description:各培训状态的数量
 *
 * @Author:chuhy
 * @create:2022/4/8 14:11
 */
@Data
@NoArgsConstructor
public class UserTrainStatusNumVo implements Serializable {
    private static final long serialVersionUID = -450114451351087608L;

    private Integer trainStatusName;

    private Integer trainStatus;

    private Integer num;

    public UserTrainStatusNumVo(Integer trainStatus, long num) {
        this.trainStatus = trainStatus;
        this.num = (int) num;
    }

    public String getTrainStatusName() {
        return TuEnrollDetailStatusEnum.getName(trainStatus);
    }
}
