package cn.smarthse.radiationTraining.modules.training.vo.training;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCoursePersonType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 培训-课程vo
 *
 * @Author:chuhy
 * @create:2022/3/31
 */
@EqualsAndHashCode(callSuper = true)
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class TrainingNewCourseVo extends UserEditParam implements Serializable {

    private static final Long serialVersionUID = -3169507075446782222L;


    //@ApiModelProperty(value = "培训课程组-课程id(这是training_course表的Id)")
    private Long id;


    //@ApiModelProperty(value = "培训课程组id(这是training_course_group表的Id)")
    private Long trainCourseGroupId;

    //@ApiModelProperty("培训ID")
    private Long tid;

    //@ApiModelProperty("课程组id")
    private Long courseGroupId;

    //@ApiModelProperty("课程序号")
    private Integer courseIndex;

    //@ApiModelProperty("课程id")
    private Long courseId;

    //@ApiModelProperty("课程名称")
    private String courseName;

    //@ApiModelProperty("课时")
    private Double classHour;

    //@ApiModelProperty(value = "课程工作类别集合",hidden = true)
    private String workCode;

    //@ApiModelProperty(value = "课程人员类型集合",hidden = true)
    private String personCode;

    //@ApiModelProperty("课程工作类别code集合")
    private List<String> workTypeCodes;

    //@ApiModelProperty("课程人员类型code集合")
    private List<String> personTypeCodes;

    //@ApiModelProperty("课程人员学习状态集合")
    private List<TrainingCoursePersonType> personTypeStudyList;

    //@ApiModelProperty("行业code集合")
    private List<String> industryCodes;

    //@ApiModelProperty("试卷总分")
    private Integer totalScore;

    //@ApiModelProperty("课程时长")
    private Long courseDuration;

    //@ApiModelProperty("是否考试(0-否；1-是)")
    private Byte isTest;

    //@ApiModelProperty("是否必过(0-否；1-是)")
    private Byte isPass;

    //@ApiModelProperty("答题时长(分钟)")
    private Integer testDuration;

    //@ApiModelProperty("及格分数")
    private Integer passingScore;



    //@ApiModelProperty("考试分数")
    private Integer testScore;

    //@ApiModelProperty("已学习时长")
    private String studiedDuration;

    //@ApiModelProperty("课程学习状态(0-未学习；1-学习中；2-已完成)")
    private Byte studyStatus;


    // 冗余信息
    //@ApiModelProperty(value = "试卷结构id")
    private Long paperStructureId;
    //@ApiModelProperty("讲师名称")
    private String lecturer;

    //@ApiModelProperty("课程类别（0通识课 1专业课）枚举：CourseTypeEnum")
    private Integer courseType;

    //@ApiModelProperty("简介")
    private String description;

    //@ApiModelProperty("封面id")
    private Long coverId;

    //@ApiModelProperty("封面url")
    private String coverUrl;

    //@ApiModelProperty("视频时长")
    private Long videoDurationSec;

    //@ApiModelProperty("视频url")
    private String videoUrl;
    //@ApiModelProperty("视频id")
    private Long videoId;

    //@ApiModelProperty("行业code，英文逗号隔开")
    private String industry;
    //@ApiModelProperty("危害因素code，英文逗号隔开")
    private String riskFactor;
    //@ApiModelProperty("人员类型code，英文逗号隔开")
    private String personTypeCode;
    //@ApiModelProperty("主要负责人课程学习状态（1-需要学习；2-无需学习）")
    private Integer majorStudyStatus;
    //@ApiModelProperty("管理员课程学习状态（1-需要学习；2-无需学习）")
    private Integer managerStudyStatus;


    //@ApiModelProperty("是否被更新")
    private Boolean isUpdated;

    //@ApiModelProperty("（前端冗余字段，用于他们判断使用，与业务无关）课程是否可删除")
    private Boolean deletable;

}
