package cn.smarthse.radiationTraining.modules.training.vo.training;

import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemIndustry;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemPersonType;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseWorkTypeVo;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 培训-课程组vo
 * 用于存放一次性返回课程组时的对象
 *
 * @Author:chuhy
 * @create:2022/3/31
 */
@Data
public class TrainingNewCourseGroupVo implements Serializable {

    private static final Long serialVersionUID = -3169507075446782277L;


    //@ApiModelProperty("培训课程组id(即trainCourseGroupId)")
    private Long id;

    //@ApiModelProperty("课程组序号")
    private Integer groupIndex;

    //@ApiModelProperty("课程组Id")
    private Long courseGroupId;

    //@ApiModelProperty("课程组名称")
    private String courseGroupName;

    //@ApiModelProperty("适用工作类别")
    private List<CourseWorkTypeVo> workType;

    //@ApiModelProperty("人员类型")
    private List<CourseItemPersonType> personType;

    //@ApiModelProperty("行业")
    private List<CourseItemIndustry> industryList;

    //@ApiModelProperty("行业code，英文逗号隔开")
    private String industry;
    //@ApiModelProperty("危害因素code，英文逗号隔开")
    private String riskFactor;
    //@ApiModelProperty("人员类型code，英文逗号隔开")
    private String personTypeCode;

    //@ApiModelProperty("课程集合")
    private List<TrainingNewCourseVo> courseList;

    //@ApiModelProperty("（前端冗余字段，用于他们判断使用，与业务无关）系统的默认课程组不能删除")
    private Integer isSystem;

}
