package cn.smarthse.radiationTraining.modules.training.vo.training;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Description:培训列表 vo
 *
 * @Author:chuhy
 * @create:2022/3/11 10:09
 */
@Data
@NoArgsConstructor
public class TrainingListVo implements Serializable {
    private static final Long serialVersionUID = -6126171785577774820L;

    //@ApiModelProperty("培训id")
    private Long id;

    //@ApiModelProperty("培训名称")
    private String trainName;

    //@ApiModelProperty("培训模式(0-专业; 1-精准;2-服务机构)")
    private Integer trainMode;

    //@ApiModelProperty("培训对象(TrainTargetEnum)")
    private Integer trainTarget;

    //@ApiModelProperty("培训区域id")
    private Long trainArea;

    //@ApiModelProperty("培训区域名称")
    private String trainAreaName;

    //@ApiModelProperty("报名开始时间")
    private Date signStarTime;

    //@ApiModelProperty("报名截止时间")
    private Date signEndTime;

    //@ApiModelProperty("培训开始时间")
    private Date trainStarTime;

    //@ApiModelProperty("培训截止时间")
    private Date trainEndTime;

    /**
     * 是否收费(0-不收费；1-收费)
     */
    private Byte isCharge;

    /**
     * 收费金额
     */
    private BigDecimal price;

    @JsonIgnore
    //@ApiModelProperty(value = "适用工作类别Vo集合",hidden = true)
    private List<TrainingWorkTypeVo> trainWorkTypeVoList;

    @JsonIgnore
    //@ApiModelProperty(value = "适用工作类别Code集合(Code和名称在这里不是一一对应的)",hidden = true)
    private String trainWorkTypeCodeList;

    //@ApiModelProperty("适用工作类别名称集合")
    private String trainWorkTypeNameList;

    //@ApiModelProperty("人员类别名称集合")
    private String personTypeNameList;

    //@ApiModelProperty("行业名称集合")
    private String trainIndustryNameList;

    //@ApiModelProperty("课程数")
    private Integer courseNum;

    //@ApiModelProperty("精准培训 - 目标学时")
    private Double targetClassHour;

    //@ApiModelProperty("培训类型")
    private String trainType;

    //@ApiModelProperty("目标证书")
    private Long targetCertificate;

    //@ApiModelProperty("目标证书名称")
    private String certificateName;

    //@ApiModelProperty("已报名人数")
    private Integer enrollNum;

    //@ApiModelProperty("待培训人数")
    private Integer untrainedNum;

    //@ApiModelProperty("待考试人数")
    private Integer untestedNum;

    //@ApiModelProperty("已取证人数")
    private Integer hasCertificateNum;

    //@ApiModelProperty("完成取证企业数")
    private Integer companyCetNum;

    //@ApiModelProperty("是否已报名(0-未报名；1-已报名)")
    private Integer isEnroll;

    //@ApiModelProperty("状态 (0-已下架；1-草稿；2-已上架)")
    private Byte status;

    //@ApiModelProperty("单位用户培训状态(0-退回；1-待培训；2-培训中；4-培训结束)/个人用户培训状态(0-退回；1-待培训；2-培训中；3-已取证；4-培训结束 5-草稿)")
    private Byte trainStatus;

    //@ApiModelProperty("封面url")
    private String coverUrl;

    //@ApiModelProperty("排序")
    private Integer weight;

    //@ApiModelProperty(value = "可编辑区域id")
    private Long couldModifyArea;

    //@ApiModelProperty(value = "创建者id")
    private Long createBy;

    //@ApiModelProperty(value = "创建者名称")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String createName;

    //@ApiModelProperty("是否可修改(0-不可修改；1-可以修改)")
    private Integer isModify = 0;

    //@ApiModelProperty(value = "培训版本")
    private String version;

    //@ApiModelProperty("受训单位名称")
    private String unitName;

    //@ApiModelProperty("已完成学时")
    private Double studiedClassHour;

    //@ApiModelProperty("课时及格线")
    private Double passClassHour;

    public TrainingListVo(Long id, Integer isEnroll, Integer weight) {
        this.id = id;
        this.isEnroll = isEnroll;
        this.weight = weight;
    }
}
