package cn.smarthse.radiationTraining.modules.training.vo.training;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @ClassName CourseVo
 * @Description 返回给前端用户数据的对象
 * @Author ChenLiang
 * @ModifyDate 2022/3/11 13:10
 */
@Data
@Accessors(chain = true)
public class TrainingCourseItemVo implements Serializable {

    private static final long serialVersionUID = 5498035043787220813L;

    //@ApiModelProperty("编号")
    private Long id;
    //@ApiModelProperty("课程组id")
    private Long trainingGroupId;
    //@ApiModelProperty("排序")
    private Long sequence;

    //@ApiModelProperty("课程名称")
    private String name;

    //@ApiModelProperty("讲师名称")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String lecturer;

    //@ApiModelProperty("简介")
    private String description;

    //@ApiModelProperty("工作类别")
    private List<String> workTypeCodes;

    //@ApiModelProperty("工作类别名称")
    private List<String> workTypeNames;

    //@ApiModelProperty("工作类别字符串，逗号隔开")
    private String workTypeNamesStr;

    //@ApiModelProperty("封面，文件表id")
    private Long coverId;

    //@ApiModelProperty("封面url")
    private String coverUrl;

    //@ApiModelProperty("视频，文件表id")
    private Long videoId;

    //@ApiModelProperty("视频url")
    private String videoUrl;

    //@ApiModelProperty("腾讯视频id")
    private String txVideoId;

    //@ApiModelProperty("腾讯视频url")
    private String txVideoUrl;

    //@ApiModelProperty("学习时长")
    private Long stuDurationSec;

    //@ApiModelProperty("是否考试(0否 1是)")
    private byte isTest;
    //@ApiModelProperty("是否过(0否 1是)")
    private byte isPass;
    //@ApiModelProperty("课程学习状态：0-未学习；1-学习中；2-已完成")
    private Integer stuStatus ;
    //@ApiModelProperty("考试状态状态：0-待考试；1-未通过；2-已通过")
    private Integer examStatus ;
    //@ApiModelProperty("重考次数限制")
    private Integer retestLimit ;
    //@ApiModelProperty("考试分数")
    private Integer score ;


    //@ApiModelProperty("试卷结构表id")
    private Long paperStructureId;

    //@ApiModelProperty("试卷结构表名称")
    private String paperStructureName;

    //@ApiModelProperty("试卷总分")
    private String totalScore;

    //@ApiModelProperty("视频时长")
    private Long videoDurationSec;


    //@ApiModelProperty("考试信息")
    private ExamAlertInfoVo examAlertInfoVo;

    //@ApiModelProperty("状态（0-草稿，1-停用，2-禁用）")
    private Long status;

    //@ApiModelProperty("状态（0-草稿，1-停用，2-禁用）")
    private String statusName;

    //@ApiModelProperty("创建人")
    private Long createBy;

    //@ApiModelProperty("更新人")
    private Long updateBy;

    //@ApiModelProperty("创建时间")
    private Date createDate;

    //@ApiModelProperty("更新时间")
    private Date updateDate;

    //@ApiModelProperty("是否有效（0-无效，1-有效）")
    private Long isValid;

    public String getStatusName(){
        String name = "";
        if(this.status == null){
            return null;
        }
        if(this.status == 0){
            name = "草稿";
        }else if(this.status == 1){
            name = "停用";
        }else if(this.status == 2){
            name = "禁用";
        }else{
            name = "禁用";
        }
        return name;
    }

    public Long getStuDurationSec() {
        //如果学习时长超过总时长就返回学习时长
        if(this.stuDurationSec != null && this.videoDurationSec != null){
            return this.stuDurationSec >= this.videoDurationSec ? this.videoDurationSec : this.stuDurationSec;
        }else {
            return this.stuDurationSec;
        }
    }
}
