package cn.smarthse.radiationTraining.modules.training.vo.training;

import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingPersonCertificate;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Description:培训-基本信息 vo
 *
 * @Author:chuhy
 * @create:2022/3/18
 */
@Data
public class TrainingBaseInfoVo implements Serializable {
    private static final long serialVersionUID = -5714726753062187784L;

    //@ApiModelProperty("培训id")
    private Long id;

    //@ApiModelProperty("报名id")
    private Long enrollId;

    //@ApiModelProperty("报名详情id")
    private Long enrollDetailId;

    //@ApiModelProperty("用户证书id")
    private Long tuCetId;

    //@ApiModelProperty("培训名称")
    private String trainName;

    //@ApiModelProperty("单位名称")
    private String unitName;

    //@ApiModelProperty("培训模式(0-专业; 1-精准;2-服务机构)")
    private Integer trainMode;

    //@ApiModelProperty("培训对象(0-用人单位；11-技术服务机构；12-职业健康体检机构；13-技术服务、职业健康体检机构)")
    private Integer trainTarget;

    //@ApiModelProperty("报名开始时间")
    private Date signStarTime;

    //@ApiModelProperty("报名结束时间")
    private Date signEndTime;

    //@ApiModelProperty("培训开始时间")
    private Date trainStarTime;

    //@ApiModelProperty("培训结束时间")
    private Date trainEndTime;

    //@ApiModelProperty("考试截止时间")
    private Date testEndTime;

    //@ApiModelProperty("是否在线考试(0-否；1-是)")
    private Integer isTestOnline;

    //@ApiModelProperty("考试方式(0-分别考试；1-统一考试)")
    private Byte testMode;

    //@ApiModelProperty("适用工作类别")
    private String workType;

    //@ApiModelProperty("适用工作类别集合")
    private List<String> workTypeList;

    //@ApiModelProperty("行业")
    private String trainIndustryNameList;

    //@ApiModelProperty("人员类型名称")
    private String personTypeNameList;

    //@ApiModelProperty("人员类型code")
    private String personTypeCode;

    //@ApiModelProperty("单位名称")
    private String companyName;

    //@ApiModelProperty("人员类别及证书信息")
    private List<TrainingPersonCertificate> personCertificateList;

    //@ApiModelProperty("培训类型")
    private String trainType;

    //@ApiModelProperty("是否收费(0-不收费；1-收费)")
    private Byte isCharge;

    //@ApiModelProperty("目标证书")
    private Long targetCertificate;

    //@ApiModelProperty("目标证书名称")
    private String certificateName;

    //@ApiModelProperty("封面url")
    private String coverUrl;

    //@ApiModelProperty("培训课程数")
    private Integer courseNum;

    //@ApiModelProperty("是否已报名(0-未报名；1-已报名)")
    private Byte isEnroll;

    //@ApiModelProperty("个人用户培训状态(0-退回；1-待培训；2-培训中；3-已取证；4-培训结束 5-待报名)")
    private Byte trainStatus;

    //@ApiModelProperty("人脸识别(0-不需要;1-需要)")
    private Byte isFaceRecognition;

    //@ApiModelProperty("统一考试 - 答题时长(分钟)")
    private Integer testDuration;

    //@ApiModelProperty("统一考试 - 考卷题目")
    private String testQuestionsNum;

    //@ApiModelProperty("统一考试 - 总分")
    private Integer totalScore;

    //@ApiModelProperty("统一考试 - 剩余考试次数")
    private Integer retestLimit;

    //@ApiModelProperty("统一考试 - 考试状态(0-待考试；1-未通过；2-已通过)")
    private Integer testStatus;

    //@ApiModelProperty("包考试含未通过课程")
    private Boolean isIncludeFlunked = false;

    //@ApiModelProperty("状态(0-已下架；1-草稿；2-已上架)")
    private Integer status;

    //@ApiModelProperty("培训版本")
    private String version = "43753";


    //@ApiModelProperty("精准培训 - 目标学时")
    private Double targetClassHour;

    //@ApiModelProperty("精准培训 - 通用课程学时")
    private Double generalClassHour;

    //@ApiModelProperty("已完成学时")
    private Double studiedClassHour;

    //@ApiModelProperty("课时及格线")
    private Double passClassHour;

    //@ApiModelProperty("以学习课程数")
    private Integer studiedProgress;

    //@ApiModelProperty("总课程进度")
    private Integer studyProgressTotal;

    //@ApiModelProperty("培训的 学时数")
    private Double classHourNum;

    //@ApiModelProperty("考试进度")
    private String testedProgress;

    //@ApiModelProperty("考试进度")
    private String testedProgressTotal;

}
