package cn.smarthse.radiationTraining.modules.training.vo.training;

import cn.smarthse.radiationTraining.core.framework.annotation.BeanPropertyName;
import lombok.Data;

import java.io.Serializable;

/**
 * Description:
 *
 * @Author:chuhy
 * @create:2022/8/29 10:30
 */
@Data
public class TrainChangeRecordVo implements Serializable {
    private static final long serialVersionUID = 6274504721551155284L;

    @BeanPropertyName(name = "培训名称")
    private String trainName;

    @BeanPropertyName(name = "报名结束时间")
    private String signEndTime;

    @BeanPropertyName(name = "培训开始时间")
    private String trainStarTime;

    @BeanPropertyName(name = "培训结束时间")
    private String trainEndTime;

    @BeanPropertyName(name = "培训类型")
    private String trainType;

    // (0-不收费；1-收费)
    @BeanPropertyName(name = "是否收费")
    private String isCharge;

    // (0-否；1-是)
    @BeanPropertyName(name = "是否在线考试")
    private String isTestOnline;

    @BeanPropertyName(name = "培训区域id")
    private String trainArea;

    // (-10 不限次数)
    @BeanPropertyName(name = "重考次数限制")
    private String retestLimit;

    // (0-原题重考；1-原题打乱；2-重组试卷)
    @BeanPropertyName(name = "重考设置")
    private String retestSetting;

    // (0-分别考试；1-统一考试)
    @BeanPropertyName(name = "考试方式")
    private String testMode;

    // (1-学院共用；2-随机分配)
    @BeanPropertyName(name = "试卷使用方式")
    private String testPaperUsage;

    // (0-已下架；1-草稿；2-已上架)
    @BeanPropertyName(name = "状态")
    private String status;

    // (0-不需要;1-需要)
    @BeanPropertyName(name = "人脸识别")
    private String isFaceRecognition;

    /**
     * 统一考试
     */
    @BeanPropertyName(name = "试卷结构表名称")
    private String paperStructureName;

    @BeanPropertyName(name = "总分")
    private String totalScore;

    @BeanPropertyName(name = "答题时长(分钟)")
    private String testDuration;

    @BeanPropertyName(name = "及格分数")
    private String passingScore;

    // //人员类型是否被修改(0-否；1-是)
    // @BeanPropertyName(name=value = "人员类型")
    // private Integer isPersonTypeModify;
    // //行业是否被修改(0-否；1-是)
    // @BeanPropertyName(name=value = "行业")
    // private Integer isIndustryModify;
}