package cn.smarthse.radiationTraining.modules.training.vo.training;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 协会培训-成绩列表 Vo
 *
 * @author chuhy
 */
@Data
public class AssoScoreListVo implements Serializable {
    private static final long serialVersionUID = 8342666874598214204L;

    /**
     *  培训id
     */
    private Long tid;

    /**
     * 个人报名信息id
     */
    private Long tdId;

    /**
     * 培训名称
     */
    private String trainName;

    /**
     * 培训类型
     */
    private String trainType;

    /**
     * 培训起始时间
     */
    private Date trainStarTime;

    /**
     * 培训结束时间
     */
    private Date trainEndTime;

    /**
     * 证书类型
     */
    private String personTypeName;

    /**
     * 姓名
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String uname;

    /**
     * 账号
     */
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String username;

    /**
     * 身份证号
     */
    @Desensitization(type = DesensitizationType.ID_CARD)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String idCard;

    /**
     * 手机号
     */
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String phone;

    /**
     * 所在单位
     */
    private String cname;

    /**
     * 分数
     */
    private Integer score;

    /**
     * 是否通过（1-未通过；2-已通过）
     */
    private Integer result;

    /**
     * 最近一次考试时间
     */
    private Date latestExamTime;


    /*public String getPhone() {
        // 手机号脱敏
        return DesensitizationUtils.desensitized(phone, DesensitizationType.MOBILE_PHONE);
    }

    public String getIdCard() {
        // 身份证脱敏
        return StringUtils.desensitizationCertificateNumber(idCard);
    }

    public String getUname() {
        // 姓名脱敏
        return DesensitizationUtils.desensitized(uname, DesensitizationType.NAME);
    }

    // 账号脱敏
    public String getUsername() {
        return StringUtils.desensitizationUsernameNumber(username);
    }*/
}