package cn.smarthse.radiationTraining.modules.training.vo.training;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 成绩 - 综合搜索vo
 */
@Data
public class ApiScoreSearchVo implements Serializable {
    private static final long serialVersionUID = 8863591998491604178L;

    private Long id;

    /**
     * 成绩
     */
    private Integer score;

    /**
     * 姓名
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String uname;

    /**
     * 手机号
     */
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String phone;

    /**
     * 所在单位
     */
    private String cname;

    /**
     * 最近一次考试完成时间
     */
    private Date latestExamTime;

    /**
     * 是否通过（1-未通过；2-已通过）
     */
    private Integer result;

    /**
     * 培训类型
     */
    private String trainType;

}
