package cn.smarthse.radiationTraining.modules.training.vo.enroll;

import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemRadiation;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @ClassName StaffTrainingDetailVo
 * @Description 员工培训详情
 * @Author ChenLiang
 * @ModifyDate 2022/3/29 13:32
 */
@Data
@Accessors(chain = true)
public class StaffTrainingDetailVo implements Serializable {
    //@ApiModelProperty("课程id")
    private Long courseItemId;
    //@ApiModelProperty("学习记录id")
    private Long tuCourseId;
    //@ApiModelProperty("状态（0-未学习；1-学习中；2-已完成，3-待考试；4-未通过；5-已通过）")
    private Integer status;
    //@ApiModelProperty("状态（0-未学习；1-学习中；2-已完成，3-待考试；4-未通过；5-已通过）")
    private String statusName;
    //@ApiModelProperty("课程名称")
    private String courseName;
    //@ApiModelProperty("是否考试")
    private Boolean isTest;
    //@ApiModelProperty("是否比过")
    private Boolean isPass;
    //@ApiModelProperty("分数")
    private Integer score;
    //@ApiModelProperty("课程学习状态：0-未学习；1-学习中；2-已完成")
    private Integer stuStatus;
    //@ApiModelProperty("考试状态：0-待考试；1-未通过；2-已通过")
    private Integer testStatus;
    //@ApiModelProperty("危害因素")
    List<CourseItemRadiation> courseItemRadiationList;
    //@ApiModelProperty("危害因素")
    String riskFactors;




    public Integer getStatus() {
        if(this.isTest == null){
            return stuStatus;
        }

        if(this.isTest == false){
            return stuStatus;
        }else{
            if(stuStatus == 2){
                return testStatus + 3;
            }else {
                return stuStatus;
            }
        }
    }

    public String getStatusName() {
        Integer currStatus = this.getStatus();
        this.statusName = "-1";
        switch (currStatus){
            case 0: this.statusName = "未学习";break;
            case 1: this.statusName = "学习中";break;
            case 2: this.statusName = "已完成";break;
            case 3: this.statusName = "待考试";break;
            case 4: this.statusName = "未通过";break;
            case 5: this.statusName = "已通过";break;
            default: statusName = "-1";
        }
        return this.statusName;
    }

}
