package cn.smarthse.radiationTraining.modules.training.vo.enroll;

import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @ClassName CropCollSignUpVo
 * @Description 单位批量报名结果信息
 * @Author ChenLiang
 * @ModifyDate 2022/3/24 10:32
 */
@Data
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
public class EnrollOptVo implements Serializable {
    //@ApiModelProperty("状态码 0：错误 1：正确")
    private Integer code;
    //@ApiModelProperty("邮箱")
    private String email;
    //@ApiModelProperty("姓名")
    private String name;
    //@ApiModelProperty("身份证")
    private String idCard;
    //@ApiModelProperty("信息")
    private String msg;
    //@ApiModelProperty("报名信息")
    private TuEnrollDetail tuEnrollDetail;
    //@ApiModelProperty("其他信息信息")
    private Object otherData;




    public EnrollOptVo(String email, String name, String idCard, String msg) {
        this.email = email;
        this.name = name;
        this.idCard = idCard;
        this.msg = msg;
    }


    public EnrollOptVo(Integer code, String email, String name, String idCard, String msg, TuEnrollDetail tuEnrollDetail) {
        this.code = code;
        this.email = email;
        this.name = name;
        this.idCard = idCard;
        this.msg = msg;
        this.tuEnrollDetail = tuEnrollDetail;
    }

    public EnrollOptVo(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }
}
