package cn.smarthse.radiationTraining.modules.training.vo.course.wx;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @ClassName CourseVo
 * @Description 返回给前端用户数据的对象
 * @Author ChenLiang
 * @ModifyDate 2022/3/11 13:10
 */
@Data
public class WxCourseItemVo implements Serializable {

    //@ApiModelProperty("编号")
    private Long id;
    //@ApiModelProperty("排序")
    private Long sequence;

    //@ApiModelProperty("课程名称")
    private String name;

    //@ApiModelProperty("讲师名称")
    private String lecturer;

    //@ApiModelProperty("简介")
    private String description;

    //@ApiModelProperty("工作类别")
    private List<String> workTypeNames;

    //@ApiModelProperty("工作类别字符串，逗号隔开")
    private String workTypeNamesStr;

    //@ApiModelProperty("封面，文件表id")
    private Long coverId;

    //@ApiModelProperty("封面，文件表id")
    private String coverUrl;

    //@ApiModelProperty("视频，文件表id")
    private Long videoId;

    //@ApiModelProperty("视频url")
    private String videoUrl;

    //@ApiModelProperty("腾讯视频id")
    private Long txVideoId;

    //@ApiModelProperty("腾讯视频url")
    private Long txVideoUrl;

    //@ApiModelProperty("试卷结构表id")
    private Long paperStructureId;

    //@ApiModelProperty("试卷结构表名称")
    private String paperStructureName;

    //@ApiModelProperty("视频时长")
    private String videoDuration;


    //@ApiModelProperty("状态（0-草稿，1-停用，2-禁用）")
    private Long status;

    //@ApiModelProperty("状态（0-草稿，1-停用，2-禁用）")
    private String statusName;

    //@ApiModelProperty("创建人")
    private Long createBy;

    //@ApiModelProperty("更新人")
    private Long updateBy;

    //@ApiModelProperty("创建时间")
    private Date createDate;

    //@ApiModelProperty("更新时间")
    private Date updateDate;

    //@ApiModelProperty("是否有效（0-无效，1-有效）")
    private Long isValid;

    public String getStatusName(){
        String name = "";
        if(this.status == 0){
            name = "草稿";
        }else if(this.status == 1){
            name = "停用";
        }else if(this.status == 2){
            name = "禁用";
        }else{
            name = "禁用";
        }
        return name;
    }
}
