package cn.smarthse.radiationTraining.modules.training.vo.course;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemPersonType;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemRadiation;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemWorkType;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @ClassName RegInfoVo
 * @Description 报名信息
 * @Author ChenLiang
 * @ModifyDate 2022/3/28 10:25
 */
@Data
@Accessors
public class EnrollInfoVo implements Serializable {
    //@ApiModelProperty(value = "基础课程id")
    private Long courseItemId;
    //@ApiModelProperty(value = "个人报名id")
    private Long id;
    //@ApiModelProperty(value = "报名来源(1-个人；2-单位；3-机构；4-医院 SysUserTypeEnum)")
    private String enrollSource;

    //@ApiModelProperty(value = "身份证")
    private String idCard;
    //@ApiModelProperty(value = "姓名")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String uname;

    //@ApiModelProperty(value = "邮箱")
    private String email;
    //@ApiModelProperty(value = "手机号")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String phone;
    //@ApiModelProperty(value = "人员类型code")
    private String personTypeCode;
    //@ApiModelProperty(value = "人员类型名称")
    private String personTypeName;
    @JsonFormat(pattern = "yyy-MM-dd HH:mm:ss")
    //@ApiModelProperty(value = "审核时间")
    private Date updateTime;

    //@ApiModelProperty(value = "报名时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date enrollTime;

    //@ApiModelProperty(value = "课程数")
    private Integer courseItemNum;

    //@ApiModelProperty(value = "课程完成数")
    private Integer completionNum;

    //@ApiModelProperty(value = "考试数")
    private Integer testNum;

    //@ApiModelProperty(value = "测试完成数")
    private Integer testCompletionNum;

    //@ApiModelProperty(value = "学习进度")
    private String learnSchedule;

    //@ApiModelProperty(value = "考试")
    private String testSchedule;

    //@ApiModelProperty(value = "证书id")
    private String tuCertificateId;

    //@ApiModelProperty(value = "证书url")
    private String pdfUrl;
    //@ApiModelProperty("证书人员类型")
    private String certType;

    List<CourseItemWorkType> courseItemWorkTypeList;
    List<CourseItemPersonType> courseItemPersonTypeList;
    List<CourseItemRadiation> courseItemRadiationList;


    //@ApiModelProperty(value = "培训状态(0-退回；1-待培训；2-培训中；3-已取证；4-培训结束 5-待报名)")
    private Integer trainingStatus;

    public String getTestSchedule() {
        return this.courseItemNum+"/"+this.testCompletionNum;
    }

    public String getLearnSchedule() {
        return this.courseItemNum+"/"+this.testCompletionNum;
    }

    public String getPersonTypeName() {
        if (this.personTypeCode == null)
            return null;
        if(this.personTypeCode.equals("200001,200002") ||
                this.personTypeCode.equals("200002,200001"))
            return "主要负责人，职业卫生管理人员";
        if(this.personTypeCode.equals("200001"))
            return "主要负责人";
        if(this.personTypeCode.equals("200002"))
            return "职业卫生管理人员";
        return null;
    }
}
