package cn.smarthse.radiationTraining.modules.training.vo.course;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemIndustry;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemPersonType;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemRadiation;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemWorkType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @ClassName CourseVo
 * @Description 返回给前端用户数据的对象
 * @Author ChenLiang
 * @ModifyDate 2022/3/11 13:10
 */
@Data
public class CourseItemVo implements Serializable {

    //@ApiModelProperty("编号")
    private Long id;
    //@ApiModelProperty("排序")
    private Long sequence;

    //@ApiModelProperty("课程名称")
    private String name;

    //@ApiModelProperty("讲师名称")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String lecturer;

    //@ApiModelProperty("简介")
    private String description;
    //@ApiModelProperty("编辑人")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String editor;

    //@ApiModelProperty("观看条件（0共有，1专有）枚举：CourseItemPermissionEnum")
    private Integer permissionType;
    //@ApiModelProperty("课程类别（0通识课 1专业课）")
    private Integer courseType;

    //@ApiModelProperty("是否是重点课程")
    private Integer isKeyCourse;

    //@ApiModelProperty("重点课程试题附件")
    private String keyQuestionFids;

    //@ApiModelProperty("区域id")
    private Long areaId;
    //@ApiModelProperty("工作类型")
    List<CourseItemWorkType> courseItemWorkTypeList;
    //@ApiModelProperty("人员类型")
    List<CourseItemPersonType> courseItemPersonTypeList;
    //@ApiModelProperty("行业")
    List<CourseItemIndustry> courseItemIndustryList;
    //@ApiModelProperty("危害因素")
    List<CourseItemRadiation> courseItemRadiationList;

    //@ApiModelProperty("封面，文件表id")
    private Long coverId;

    //@ApiModelProperty("封面url")
    private String coverUrl;

    //@ApiModelProperty("视频，文件表id")
    private Long videoId;

    //@ApiModelProperty("视频url")
    private String videoUrl;

    //@ApiModelProperty("腾讯视频id")
    private String txVideoId;

    //@ApiModelProperty("腾讯视频url")
    private String txVideoUrl;

    //@ApiModelProperty("试卷结构表id")
    private Long paperStructureId;

    //@ApiModelProperty("试卷结构表名称")
    private String paperStructureName;

    //@ApiModelProperty("试卷总分")
    private String totalScore;

    //@ApiModelProperty("课时数")
    private Double classHour;

    //@ApiModelProperty("视频时长（秒）")
    private Long videoDurationSec;


    //@ApiModelProperty("状态（0-草稿，1-启用，2-禁用）")
    private Long status;

    //@ApiModelProperty("状态（0-草稿，1-启用，2-禁用）")
    private String statusName;

    //@ApiModelProperty("创建人")
    private Long createBy;

    //@ApiModelProperty("更新人")
    private Long updateBy;

    //@ApiModelProperty("创建时间")
    private Date createDate;

    //@ApiModelProperty("更新时间")
    private Date updateDate;

    //@ApiModelProperty("是否有效（0-无效，1-有效）")
    private Long isValid;

    //@ApiModelProperty("组")
    private List<CourseGroupVo> courseGroupVoList;

    //@ApiModelProperty("试题文件")
    List<CourseQuestionFileVo> questionFileVoList;

    //@ApiModelProperty("与课程组匹配提醒")
    GroupWarningVo warningVo;

    public String getStatusName() {
        String name = "";
        if (this.status == null) {
            return null;
        }
        if (this.status == 0) {
            name = "草稿";
        } else if (this.status == 1) {
            name = "启用";
        } else if (this.status == 2) {
            name = "禁用";
        } else {
            name = "禁用";
        }
        return name;
    }

}
