package cn.smarthse.radiationTraining.modules.training.vo.course;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemIndustry;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemPersonType;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemRadiation;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * @ClassName CourseGroupVo
 * @Description 返回给前端用户数据的对象
 * @Author ChenLiang
 * @ModifyDate 2022/3/11 13:10
 */
@Data
public class CourseGroupVo implements Serializable {

    //@ApiModelProperty("编号")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    //@ApiModelProperty("课程组名")
    private String name;

    //@ApiModelProperty("包含课程数量")
    private Integer count;

    //@ApiModelProperty("状态（0-关闭，1-启用）")
    private Integer status;

    //@ApiModelProperty("类型（0普通 1默认 2老极简 3新极简）")
    private Integer type;

    //1岗前 2岗中
    private Integer type2;



    //@ApiModelProperty("培训目标类型（200000用人单位 300002医用放射工作人员 300003非医用放射工作人员")
    private String trainingTargetType;

    //@ApiModelProperty("更新时间")
    private Date updateDate;

    //@ApiModelProperty("创建时间")
    private Date createDate;

    //@ApiModelProperty("编辑人")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String editor;

    //@ApiModelProperty("排序，序号越小越靠前")
    private Long sequence;

    //@ApiModelProperty("课程列表")
    List<CourseItemVo> courseItemVoList;

    //@ApiModelProperty("课程组适用工作类别,逗号隔开,可能包括重复")
    String workTypesStr;

    //@ApiModelProperty("课程组适用工作类别")
    Set<String> workTypeSet;
    //@ApiModelProperty("课程组的各种类别（对象集合）")
    List<CourseWorkTypeVo> workType;

    //@ApiModelProperty("课程组的人员类别（对象集合）")
    List<CourseItemPersonType> personTypeList;

    //@ApiModelProperty("课程组的放射危害因数（对象集合）")
    List<CourseItemRadiation> radiationList;
    //@ApiModelProperty("课程组的放射危害因数（对象集合）")
    List<CourseItemIndustry> courseItemIndustryList;

    //@ApiModelProperty(value = "课程id列表字符串，逗号隔开",hidden = true)
    private String courseItemListStr;
//    //@ApiModelProperty("课程组列表")
//    List<String> courseItemList;

    //@ApiModelProperty("课程提示消息")
    private GroupWarningVo warningVo;

}
