package cn.smarthse.radiationTraining.modules.training.vo.certificate;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName TuCertListVo
 * @Description TODO
 * @Author ChenLiang
 * @ModifyDate 2022/9/28 13:14
 */
@Data
public class TuCertListVo implements Serializable {
    //@ApiModelProperty("id")
    private Long id;

    //@ApiModelProperty("证书名称")
    private String name;

    //@ApiModelProperty("人员姓名")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String uname;

    //@ApiModelProperty("证书编号")
    private String certificateNo;

    //@ApiModelProperty("发证单位")
    private String trainingUnitName;

    //@ApiModelProperty("发证日期")
    private Date issueTime;

    //@ApiModelProperty("失效日期")
    private Date invalidDate;

    //@ApiModelProperty("复审日期")
    private Date reviewDate;

    //@ApiModelProperty("证书pdf路径")
    private String pdfUrl;

    //@ApiModelProperty("证书img路径")
    private String imgUrl;

    //@ApiModelProperty("证书类型（即：人员类型）")
    private String certType;
}
