package cn.smarthse.radiationTraining.modules.training.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.radiationTraining.modules.training.enums.InudstryAllCodeTypeEnum;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @ClassName VideoUtils
 * @Description 行业类型工具
 * @Author ChenLiang
 */
@Slf4j
public class IndustryTypeUtils {
    
    public static boolean containMedicalIndustry(List<String> industryList){
        if(CollUtil.isEmpty(industryList)){
            return false;
        }
        for (String i : industryList) {
            if(StrUtil.equals(i,"Q") || StrUtil.startWith(i,"Q84") || i.equals(InudstryAllCodeTypeEnum.ALL_MEDICAL.getValue()) || i.equals(InudstryAllCodeTypeEnum.ALL.getValue())){
                return true;
            }
        }
        return false;
    }

    public static boolean containNonMedicalIndustry(List<String> industryList){
        if(CollUtil.isEmpty(industryList)){
            return false;
        }
        for (String i : industryList) {
            if(StrUtil.equals(i,"Q")  || i.equals(InudstryAllCodeTypeEnum.ALL_NON_MEDICAL.getValue()) || i.equals(InudstryAllCodeTypeEnum.ALL.getValue())){
                return true;
            }

            if(!i.equals(InudstryAllCodeTypeEnum.ALL_MEDICAL.getValue()) && !StrUtil.startWith(i,"Q84")){
                return true;
            }
        }
        return false;
    }

}