package cn.smarthse.radiationTraining.modules.training.provider.training;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.training.dto.ImportRaTuCertDto;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.RaTuCertificate;
import cn.smarthse.radiationTraining.modules.training.entity.training.RaTraining;
import cn.smarthse.radiationTraining.modules.training.param.course.SyncRaCertParam;
import cn.smarthse.radiationTraining.modules.training.param.training.RaTuCertificateEditParam;
import cn.smarthse.radiationTraining.modules.training.param.training.RaTuCertificateParam;

import java.util.List;

/**
 * ITrainingProviderService
 */
public interface IRaTrainingProviderService {

    LayuiGridData<RaTraining> getTrainingList(RaTuCertificateParam param);

    LayuiGridData<RaTuCertificate> getCertList(RaTuCertificateParam param);

    RaTraining addRaTraining(RaTraining training);

    void submit(RaTuCertificateParam param);

    void clearCertData(RaTuCertificateParam param);

    void importTrainAboutCert(List<ImportRaTuCertDto> list, Long loginUserId);

    RaTuCertificate getCertDetail(Long id);

    void saveCertDetail(RaTuCertificateEditParam param);

    void delTraining(Long id);

    RaTraining getTrainingById(Long id);

    void syncCertData(SyncRaCertParam param);
}
