package cn.smarthse.radiationTraining.modules.training.provider.certificate;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.TuCertificate;
import cn.smarthse.radiationTraining.modules.training.param.TuCertificatePageParam;
import cn.smarthse.radiationTraining.modules.training.param.UpdateCertificateParam;
import cn.smarthse.radiationTraining.modules.training.param.training.MyCertificateParam;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.*;

import java.util.List;

/**
 * @ClassName ITrainingProviderService
 * @Description 我的证书 接口
 * @Author wuxq
 * @Date 2022/3/21
 */
public interface ITuCertificateProviderService {

    /**
     * 方法描述:  已取证列表
     *
     * @param   param
     * @return  LayuiGridData<MyCertificateVo>
     * @author  wuxq
     * @date    2022/5/7
     */
    LayuiGridData<MyCertificateVo> getMyCertificateList(MyCertificateParam param);

    /**
     * @description: 我的证书（统计）
     * @author: chenliang
     * @date: 2023/9/20 9:06
     * @param param
     * @return: {@link CertTrainVo}
     */
    CertTrainVo getMyCertificateListCount(MyCertificateParam param);

    /**
     * 已生成证书培训列表(web端)
     *
     * @author  chuhy
     */
    LayuiGridData<CertTrainVo> getHasCetTrainList(MyCertificateParam param);

    /**
     * 培训对应证书(web端)
     *
     * @author  chuhy
     */
    List<MyCertificateVo> getTrainCetList(MyCertificateParam param);

    /**
     * 用户培训下的 已取证列表
     *
     * @param   enrollDetailId 报名详情id
     * @return  List<MyCertificateVo>
     * @author  wuxq
     * @date    2022/5/7
     */
    List<MyCertificateVo> getMyCertificateList(Long enrollDetailId);

    /**
     * @description 添加证书基础数据
     * @param enrollDetailId
     * @return void
     * @author chenliang
     * @date 2022/8/25 18:35:25
     */
    void addCertificate(Long enrollDetailId);

    /**
     * 方法描述:  我的证书-详情
     *
     * @param  id 我的证书id
     * @param uid 账号id
     * @return  TuCertVo
     * @author  wuxq
     * @date    2022/5/10
     */
    TuCertVo getMyCertificateDetailById(Long id, Long uid);


    /**
     * 保存证书文件
     * @param enrollDetailId 用户报名id
     * @param pdfUrl 证书pdf文件路径
     * @param imgUrl 证书图片文件路径
     */
    void saveCertificateFile(Long enrollDetailId,String pdfUrl, String imgUrl);

    /**
     * 更新证书数据
     * @param updateCertificateVo
     */
    TuCertificate upDateCertificateFile(UpdateCertificateParam updateCertificateVo);

    /**
     * 生成证书pdf，返回证书信息
     * @param id 证书id
     * @return {@link TuCertVo}
     * @author liaoly
     * @date 2022/8/24 15:21
     */
    TuCertVo genCertFile(Long id);
    void genCertFile();

    /**
     * 根据id查证书,并发送邮箱
     * @param id 证书id
     * @author chuhy
     */
    void SendCertificate(Long id);

    /**
     * 用户证书二维码预览 信息
     * @param certId 证书id
     * @return {@link TuCertQrVo}
     * @author liaoly
     * @date 2022/10/12 14:26
     */
    TuCertQrVo getTuCertQrVo(Long certId);

    /**
     * @description 分页条件搜索
     * @param param
     * @return TuCertListVo
     * @author chenliang
     * @date 2022/9/28 13:46:43
     */
    LayuiGridData<TuCertListVo> getList(TuCertificatePageParam param);

    void reSynceAllExceptionInfo();

    void syncSingleInfo(Long certId);

    void cleanCert(Long certId);
}
