package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 培训上下架状态参数对象
 *
 * @author chuhy
 * @date
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class TrainingStatusUpdateParam extends UserEditParam {
    private static final Long serialVersionUID = 1025310756760765593L;

    //@ApiModelProperty(value = "职业健康在线-监管账号id", hidden = true)
    private String token;

    //@ApiModelProperty("培训ID集合")
    private List<Long> trainIdList;

    //@ApiModelProperty("状态(0-已下架；1-草稿；2-已上架)")
    private Integer status;

    //@ApiModelProperty("监管用户区域id")
    private Long areaId;

    //@ApiModelProperty("区域级别")
    private Integer level;

    //@ApiModelProperty(value = "修改人",hidden = true)
    private String modifyPerson;

    public Integer getLevel() {
        return StringUtils.getAreaLevel(this.areaId);
    }
}
