package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 培训清单列表参数对象
 *
 * @author chuhy
 * @date 2022/9/22
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class TrainHomeUserParam extends PageParam {

    private static final long serialVersionUID = 2851435883886642869L;

    //@ApiModelProperty(value = "监管用户区域",hidden = true)
    private Long userArea;

    //@ApiModelProperty(value = "用户区域level",hidden = true)
    private int userAreaLevel;

    //@ApiModelProperty(value = "主要负责人持证情况(0-无有效证书;1-持有效证书)")
    private Integer majorHasCet;

    //@ApiModelProperty(value = "职业卫生管理人员持证情况(0-无有效证书;1-持有效证书)")
    private Integer managerHasCet;

    //@ApiModelProperty(value = "（非医用）放射工作人员持证情况(0-无有效证书;1-持有效证书)")
    private Integer nonMedicalHasCet;

    //@ApiModelProperty(value = "主要负责人取证开始日期")
    private Date majorCetBeginDate;
    //@ApiModelProperty(value = "主要负责人取证结束日期")
    private Date majorCetEndDate;

    //@ApiModelProperty(value = "职业卫生管理人员取证 开始日期")
    private Date managerCetBeginDate;
    //@ApiModelProperty(value = "主职业卫生管理人员取证 结束日期")
    private Date managerCetEndDate;

    //@ApiModelProperty(value = "（非医用）放射工作人员取证 开始日期")
    private Date nonMedicalCetBeginDate;
    //@ApiModelProperty(value = "（非医用）放射工作人员取证 结束日期")
    private Date nonMedicalCetEndDate;


    //@ApiModelProperty(value = "是否为指定账号",hidden = true)
    private Boolean isSpecifiedUser = false;

    //@ApiModelProperty(value = "个人账号id",hidden = true)
    private List<Long> userIdList;

    public int getUserAreaLevel() {
        return StringUtils.getAreaLevel(this.userArea);
    }
}
