package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 放射专委会查询参数对象
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class RaTuCertificateParam extends PageParam {

    private static final long serialVersionUID = 1L;

    /**
     * 所在单位名称
     */
    private String unitName;

    /**
     * 状态(1-草稿；2-已提交)
     */
    private Integer status;

    /**
     * 培训主表id
     */
    private Long trainingId;

    /**
     * 记录变更，默认false
     */
    private Boolean recordChangeFlag = false;

}
