package cn.smarthse.radiationTraining.modules.training.param.training;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;

/**
 * 放射专委会培训结果
 */
@Data
public class RaTuCertificateEditParam implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;
    /**
     *
     */
    private Long id;

    /**
     * 主表id
     */
    private Long tid;

    /**
     * 姓名
     */
    private String uname;

    /**
     * 性别
     */
    private String sex;

    /**
     * 出生日期
     */
    private Date birthday;

    /**
     * 证件类型：1-身份证；2-其他
     */
    private Integer idCardType;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 证书类型（主要负责人培训证书-200001；职业卫生管理人员培训证书-200002；放射工作人员放射防护岗中培训证明-300002）
     */
    private String certType;

    /**
     * 培训类型（中文存储，放射工作人员放射防护岗中培训；企业主要负责人/管理人员继续教育）
     */
    private String trainType;

    /**
     * 证书编号
     */
    private String certificateNo;

    /**
     * 发证单位单位名称
     */
    private String trainingUnitName;

    /**
     * 所在用人单位名称
     */
    private String unitName;
    /**
     * 所在用人单位统一社会信用代码
     */
    private String unitCreditCode;

    /**
     * 培训结果：0-不合格；1-合格
     */
    private Integer trainingResult;

    /**
     * 发证日期
     */
    private Date issueTime;

    /**
     * 失效日期
     */
    private Date invalidDate;

}
