package cn.smarthse.radiationTraining.modules.training.param.enroll;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @ClassName SearchStaffTrainingDetailParam
 * @Description 查看员工培训详情
 * @Author ChenLiang
 * @ModifyDate 2022/3/29 13:29
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
public class SearchStaffTrainingDetailParam extends PageParam implements Serializable {
    //@ApiModelProperty(value = "公司id")
    private Long cid;
    //@ApiModelProperty(value = "员工报名表id")
    private String enrollDetailId;

    //@ApiModelProperty(value = "人员类型")
    private String pensonCode;

    //@ApiModelProperty(value = "危害因数类型")
    private String riskFactorCode;

    //@ApiModelProperty(value = "状态(0-未学习；1-学习中；2-已完成 3-待考试；4-未通过；5-已通过)")
    private Integer status;

    //@ApiModelProperty(value = "学习状态(0-未学习；1-学习中；2-已完成；)", hidden = true)
    private Integer stuStatus;
    //@ApiModelProperty(value = "考试状态(0-待考试；1-未通过；2-已通过)", hidden = true)
    private Integer testStatus;


    public Integer getStuStatus() {
        if(this.status == null) {return null;}
        return this.status < 3 ? status : null;
    }

    public Integer getTestStatus() {//前端传过来的4-未通过；5-已通过错误，分别减了1，所以这里特殊处理
        if(this.status == null) {return null;}
        if(this.status >= 3){
            if(this.status == 3){
                return 1;
            }else{
                return 2;
            }
        }else {
            return null;
        }
    }
}
