package cn.smarthse.radiationTraining.modules.training.param.enroll;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @ClassName CropSignUpParam
 * @Description 单位报名参数
 * @Author ChenLiang
 * @ModifyDate 2022/3/23 15:09
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
public class SaveStaffDraftInfoParam extends UserEditParam implements Serializable {
    //@ApiModelProperty("培训主表id")
    private Long tid;

    //@ApiModelProperty(value = "企业报名id",hidden = true)
    private Long enrollId;

    //@ApiModelProperty(value = "用户报名报名id",hidden = true)
    private Long enrollDetailId;

    //@ApiModelProperty(value = "企业id",hidden = true)
    private Long cid;

    //@ApiModelProperty(value = "用户id",hidden = true)
    private Long uid;

    //@ApiModelProperty("用户姓名")
    private String uname;

    //@ApiModelProperty("用户邮箱")
    private String email;

    //@ApiModelProperty("身份证号")
    private String idCard;

    //@ApiModelProperty(value = "来源",hidden = true)
    private String enrollSource = "2";

    //@ApiModelProperty(value = "状态（1：报名,5：草稿）")
    private String trainStatus = "1";

    //@ApiModelProperty(value = "序号（导入时使用）",hidden = true)
    private Integer index;


    public SaveStaffDraftInfoParam() {
    }

    public SaveStaffDraftInfoParam(Long tid, Long cid, String uname, String email, String idCard, String enrollSource, String trainStatus) {
        this.tid = tid;
        this.cid = cid;
        this.uname = uname;
        this.email = email;
        this.idCard = idCard;
        this.enrollSource = enrollSource;
        this.trainStatus = trainStatus;
    }
}
