package cn.smarthse.radiationTraining.modules.training.param.course;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @ClassName MatchCourseParam
 * @Description 匹配课程参数
 * @Author ChenLiang
 * @ModifyDate 2022/8/16 9:28
 */
@Data
@Accessors(chain = true)
public class MatchCourseParam implements Serializable {
    //@ApiModelProperty(value = "0初次 1继续",required = true)
    private Integer trainType;

    //@ApiModelProperty(value = "精准课程最小学时",required = true)
    private Double preciseClassHour;

    //@ApiModelProperty(value = "通用课程最小学时",required = true)
    private Double generalClassHour;

    //@ApiModelProperty(value = "人员类型集合",required = true)
    private List<String> personCodeList;

    //@ApiModelProperty(value = "危害因素集合",required = true)
    private List<String> riskCodeList;

    //@ApiModelProperty(value = "行业因素集合",required = true)
    private List<String> industryCodeList;

    //@ApiModelProperty(value = "区域",required = true)
    private Long areaId;

    //@ApiModelProperty(value = "限制",hidden = true)
    private Integer size;

    //@ApiModelProperty(value = "需要排除的课程id",hidden = true)
    private List<Long> excludeCourseItemIdList;

    //******开发v3.2.2.1加的字段start
    private Long tid;
    private String personType;
    //******开发v3.2.2.1加的字段end

}
