package cn.smarthse.radiationTraining.modules.training.param.course;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @ClassName CourseItemEditParam
 * 重点行业课程添加参数
 * @Author ChenLiang
 */

@Data
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class KeyCourseAddParam implements Serializable {
    private static final long serialVersionUID = 1L;
    //@ApiModelProperty("编号")
    private Long id;

    //@ApiModelProperty("课程名称")
    private String name;

    //@ApiModelProperty("讲师名称")
    private String lecturer;

    //@ApiModelProperty("简介")
    private String description;

    //@ApiModelProperty("人员类型")
    private List<CourseItemAddPensonParam> personTypeList;

    //@ApiModelProperty("视频时长（秒）")
    private Long videoDurationSec;

    //@ApiModelProperty("视频文件相关")
    private KeyCourseFileParam videoFileParams;

    //@ApiModelProperty("试题文件相关")
    private List<KeyCourseFileParam> fileParams;

    //@ApiModelProperty("操作人id")
    private Long optId;
}
