package cn.smarthse.radiationTraining.modules.training.param.course;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @ClassName CourseItemEditParam
 * @Description 添加或者编辑课程的请求参数类
 * @Author ChenLiang
 * @ModifyDate 2022/3/15 15:02
 */

@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CourseItemAddParam extends UserEditParam {
    //@ApiModelProperty("编号")
    private Long id;

    //@ApiModelProperty("课程名称")
    private String name;

    //@ApiModelProperty("讲师名称")
    private String lecturer;

    //@ApiModelProperty("简介")
    private String description;

    //@ApiModelProperty("人员类型")
    private List<CourseItemAddPensonParam> personTypeList;

    //@ApiModelProperty("观看条件（0专用，1通用用）枚举：CourseTypeEnum")
    private Integer courseType;

    //@ApiModelProperty("放射危害因数 ")
    private List<CourseItemAddRiskParam> radiationFactorList;

    //@ApiModelProperty("行业 ")
    private List<CourseItemAddIndustryParam> industryList;

    //@ApiModelProperty("课程组，逗号隔开")
    private String groups;

    //@ApiModelProperty("封面")
    private Long coverId;
    //@ApiModelProperty("封面")
    private String coverUrl;

    //@ApiModelProperty("视频:file表id")
    private Long videoId;
    //@ApiModelProperty("视频:fileUrl")
    private String videoUrl;

    //@ApiModelProperty("腾讯视频id")
    private String txVideoId;
    //@ApiModelProperty("观看条件（0通用，1专用）枚举：CourseItemPermissionEnum")
    private Integer permissionType;
    //@ApiModelProperty("区域id")
    private Long areaId;

    //@ApiModelProperty("腾讯视频url")
    private String txVideoUrl;

    //@ApiModelProperty("试卷结构表")
    private Long paperStructureId;

    //@ApiModelProperty("课时数")
    private Double classHour;

    //@ApiModelProperty("视频时长（秒）")
    private Long videoDurationSec;

    //@ApiModelProperty("状态（0-草稿，1-启用，2-禁用）")
    private Long status;

    //@ApiModelProperty("新添加的课程在页面上的顺序")
    private Long pageSequence;

    //@ApiModelProperty("当前课程组id，插入课程接口会使用到")
    private Long currentGrouopId;

    //@ApiModelProperty("重点课程试题附件")
    private String keyQuestionFids;

    //@ApiModelProperty("是否是重点课程")
    private Integer isKeyCourse;
}
