package cn.smarthse.radiationTraining.modules.training.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 个人培训状态 枚举
 *
 * @author chuhy
 * @date 2022/3/14
 */
@AllArgsConstructor
@Getter
public enum TuEnrollStatusEnum {

    ALL(-1, "全部"),
    RETURN(0, "退回"),
    BETRAINED(1, "待培训"),
    TRAINING(2, "培训中"),
    TRAIN_OVER(4, "培训结束"),
    TRAIN_DRAFT(5, "草稿")
    ;


    private Integer value;

    private String name;

    public static String getName(Integer v) {
        if (v == null) {
            return null;
        }

        for (TuEnrollStatusEnum e : values()) {
            if (e.getValue().equals(v)) {
                return e.getName();
            }
        }
        return null;
    }
}
