package cn.smarthse.radiationTraining.modules.training.entity.training;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * Description:培训-人员类型证书信息
 *
 * @Author:chuhy
 * @create:2022/8/8 11:26
 */
@Data
@TableName("training_person_certificate")
@NoArgsConstructor
public class TrainingPersonCertificate implements Serializable {
    
    /**
     * 
     */
    private static final Long serialVersionUID = 5939003209203652518L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 培训id
     */
    private Long tid;


    /**
     * 人员类型
     */
    private Integer personType;

    /**
     * 人员类型名称
     */
    private String personTypeName;


    /**
     * 证书背景id
     */
    private Long backgroundId;


    /**
     * 证书背景名称
     */
    private String backgroundName;

    /**
     * 姓名(展示)
     */
    private String name;

    /**
     * 性别(展示)
     */
    private String sex;

    /**
     * 证书编号(展示)
     */
    private String certificateNo;

    /**
     * 发证单位(展示)
     */
    private String awardUnit;

    /**
     * 证书有效期(年)(展示)
     */
    private Integer validityDate;

    /**
     * 身份证(0-不展示；1-展示)
     */
    private String idCard;

    /**
     * 工作单位(0-不展示；1-展示)
     */
    private Integer workUnit;

    /**
     * 培训时间(0-不展示；1-展示)
     */
    private Integer trainTime;

    /**
     *资格证书编号(0-不展示；1-展示)
     */
    private Integer qualificationCertNo;

    /**
     *培训课程(0-不展示；1-展示)
     */
    private Integer trainCourse;


    /**
     * 成绩(0-不展示；1-展示)
     */
    private Integer score;


    /**
     * 复审日期(月)-(废弃)
     */
    private Integer reviewDate;

    /**
     * 电子章url
     */
    private String electronicSeal;

    /**
     * 精准培训 - 目标学时
     */
    //@ApiModelProperty("精准培训 - 目标学时")
    private Double targetClassHour;

    /**
     * 精准培训 - 通用课程学时
     */
    //@ApiModelProperty("精准培训 - 通用课程学时")
    private Double generalClassHour;

    /**
     * 专业培训 - 个性课程学时
     */
    //@ApiModelProperty("专业培训 - 个性课程学时")
    private Double personalizedClassHour;

    /**
     * 标志数组(用于前端判断是否勾选)
     */
    private String isSelectList;
    
    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 更新人
     */
    private Long updateBy;

    /**
     * 是否有效(0-无效；1-有效)
     */
    @TableLogic
    private Boolean isValid;
}
