package cn.smarthse.radiationTraining.modules.training.entity.training;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 培训-行业关系表
 *
 * @Author:chuhy
 * @create:2022/8/15
 */
@Data
@TableName("training_industry")
@NoArgsConstructor
public class TrainingIndustry implements Serializable {
    
    /**
     * 
     */
    private static final Long serialVersionUID = 5939003209203532582L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 培训id
     */
    private Long tid;

    /**
     * 行业Code
     */
    private String industryCode;

    /**
     * 行业名称
     */
    private String industryCodeName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 更新人
     */
    private Long updateBy;

    /**
     * 是否有效(0-无效；1-有效)
     */
    @TableLogic
    private Boolean isValid;
}
