package cn.smarthse.radiationTraining.modules.training.entity.training;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@TableName("training_course")
public class TrainingCourse implements Serializable {

    private static final Long serialVersionUID = 844349057060689157L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    //@ApiModelProperty("培训ID")
    private Long tid;

    //@ApiModelProperty("表training_course_group.id")
    private Long trainCourseGroupId;

    //@ApiModelProperty("课程组ID")
    private Long courseGroupId;

    //@ApiModelProperty("课程ID")
    private Long courseId;

    //@ApiModelProperty("课程序号")
    private Integer courseIndex;

    //@ApiModelProperty("课时")
    private Double classHour;

    //@ApiModelProperty("是否考试")
    private Byte isTest;

    //@ApiModelProperty("是否必过")
    private Byte isPass;

    //@ApiModelProperty("课程时长")
    private Long courseDuration;

    @TableField(updateStrategy = FieldStrategy.NEVER,insertStrategy = FieldStrategy.NEVER)
    //@ApiModelProperty("答题时长(分钟)")
    private Integer testDuration;

    //@ApiModelProperty("及格分数")
    private Integer passingScore;

    //@ApiModelProperty("试题顺序(0-正序；1-倒序；2-乱序)")
    private Long testSequence;

    //@ApiModelProperty("创建时间")
    private Date createTime;

    //@ApiModelProperty("更新时间")
    private Date updateTime;

    //@ApiModelProperty("创建人")
    private Long createBy;

    //@ApiModelProperty("更新人")
    private Long updateBy;

    //@ApiModelProperty("是否有效(0-无效；1-有效)")
    private Byte isValid;


    /**
     * 试卷结构id
     */
    //@ApiModelProperty(value = "试卷结构id")
    private Long paperStructureId;
    /**
     * 组卷方式（默认1：自动；2：手动）
     */
    //@ApiModelProperty(value = "组卷方式（默认1：自动；2：手动）")
    private Long way;
    /**
     * 单选题数
     */
    //@ApiModelProperty(value = "单选题数")
    private Integer singleNum;
    /**
     * 多选题数
     */
    //@ApiModelProperty(value = "多选题数")
    private Integer multipleNum;
    /**
     * 填空题数
     */
    //@ApiModelProperty(value = "填空题数")
    private Integer completionNum;
    /**
     * 判断题数
     */
    //@ApiModelProperty(value = "判断题数")
    private Integer judgeNum;
    /**
     * 每个单选题分数
     */
    //@ApiModelProperty(value = "每个单选题分数")
    private Integer singleScore;
    /**
     * 每个多选题分数
     */
    //@ApiModelProperty(value = "每个多选题分数")
    private Integer multipleScore;
    /**
     * 每个填空题分数
     */
    //@ApiModelProperty(value = "每个填空题分数")
    private Integer completionScore;
    /**
     * 每个判断题分数
     */
    //@ApiModelProperty(value = "每个判断题分数")
    private Integer judgeScore;
    /**
     * 总分
     */
    //@ApiModelProperty(value = "总分")
    private Integer totalScore;


    /**
     * 课程名称
     */
    //@ApiModelProperty("课程名称")
    private String courseName;

    /**
     * 课程类别（0通识课 1专业课）枚举：CourseTypeEnum
     */
    //@ApiModelProperty("课程类别（0通识课 1专业课）枚举：CourseTypeEnum")
    private Integer courseType;

    /**
     * 讲师名称
     */
    //@ApiModelProperty("讲师名称")
    private String lecturer;

    /**
     * 简介
     */
    //@ApiModelProperty("简介")
    private String description;

    /**
     * 封面id
     */
    //@ApiModelProperty("封面id")
    private Long coverId;

    /**
     * 封面url
     */
    //@ApiModelProperty("封面url")
    private String coverUrl;

    /**
     * 视频时长
     */
    //@ApiModelProperty("视频时长")
    private Long videoDurationSec;

    /**
     * 视频url
     */
    //@ApiModelProperty("视频url")
    private String videoUrl;
    /**
     * 视频id
     */
    //@ApiModelProperty("视频id")
    private Long videoId;

    /**
     * 行业code，英文逗号隔开
     */
    //@ApiModelProperty("行业code，英文逗号隔开")
    private String industry;
    /**
     * 危害因素code，英文逗号隔开
     */
    //@ApiModelProperty("危害因素code，英文逗号隔开")
    private String riskFactor;
    /**
     * 人员类型code，英文逗号隔开
     */
    //@ApiModelProperty("人员类型code，英文逗号隔开")
    private String personTypeCode;

    //@ApiModelProperty("主要负责人课程学习状态（1-需要学习；2-无需学习）")
    private Integer majorStudyStatus;
    //@ApiModelProperty("管理员课程学习状态（1-需要学习；2-无需学习）")
    private Integer managerStudyStatus;

    //@ApiModelProperty("（前端冗余字段，用于他们判断使用，与业务无关）课程是否可删除")
    private Boolean deletable;


    @TableField(exist = false)
    //@ApiModelProperty("人员里类型code（英文逗号隔开）")
    private String personTypes;

    @TableField(exist = false)
    //@ApiModelProperty("行业code")
    private List<String> industryList;

    @TableField(exist = false)
    //@ApiModelProperty("危害因素code")
    private List<String> riskFactorList;

    @TableField(exist = false)
    //@ApiModelProperty("行业配匹级别 1 2 3")
    private Integer industryMatchingLevel;

    @TableField(exist = false)
    //@ApiModelProperty("风险配匹级别 1 2 3")
    private Integer riskMatchingLevel;

    @TableField(exist = false)
    //@ApiModelProperty("配匹度")
    private BigDecimal matchingRate;

}
