package cn.smarthse.radiationTraining.modules.training.entity.training;


import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;

/**
 * 放射专委会培训主表
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("ra_training")
@NoArgsConstructor
public class RaTraining extends BaseBean implements Serializable {

    @Serial
    private static final long serialVersionUID = 5939003209203518031L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 培训名称
     */
    private String name;

    /**
     * 培训开始时间
     */
    private Date startTime;

    /**
     * 培训结束时间
     */
    private Date endTime;

    /**
     * 培训区域id
     */
    private Long areaId;

    /**
     * 状态(1-草稿；2-已提交)
     */
    private Integer status;

    /**
     * 培训地点详情
     */
    private String addressDetail;

    /**
     * 培训地点完整地址
     */
    @TableField(exist = false)
    private String fullAddress;

}