package cn.smarthse.radiationTraining.modules.training.entity.enroll;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 培训报名详情表
 * </p>
 *
 * @author wuxq
 * @since 2022-3-18
 */
@Data
@Accessors(chain = true)
@TableName("tu_enroll_detail")
public class TuEnrollDetail implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * ID
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;
    /**
     * 培训主表id
     */
    private Long tid;
    /**
     * 用户id
     */
    private Long uid;
    /**
     * 企业报名id（tu_enroll.id）
     */
    private Long enrollId;
    /**
     * 企业id
     */
    @Deprecated
    private Long cid;
    /**
     * 职业健康系统的企业id
     */
    private Long hseCid;
    /**
     * 导入的培训id
     */
    private String importedId;
    /**
     * 批次导入编码（代码自己生成）
     */
    private String importedBatchCode;
    /**
     * 用户姓名
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String uname;
    /**
     * 邮箱
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String email;
    /**
     * 手机号
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String phone;
    /**
     * 人员类型
     */
    private String personTypeCode;
    /**
     * 身份证号
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String idCard;

    /**
     * 报名来源(1-个人；2-单位；3-机构；4-医院 SysUserTypeEnum)
     */
    private Integer enrollSource;
    /**
     * 报名时间
     */
    private Date enrollTime;
    /**
     * 已学完课程数(学习进度)
     */
    private Integer studiedProgress;
    /**
     * 总课程数(学习进度)
     */
    private Integer studyProgressTotal;
    /**
     * 已通过(考试进度)
     */
    private Integer testedProgress;
    /**
     * 必考必过课程数(考试进度)
     */
    private Integer testProgressTotal;
    /**
     * 培训状态(0-退回；1-待培训；2-培训中；3-已取证；4-培训结束 5-带报名)
     */
    private Integer trainStatus;
    /**
     * 培训模式(0-专业; 1-精准;2-服务机构)
     */
    private Integer trainMode;
    /**
     * 已完成学时
     */
    private Double studiedClassHour;
    /**
     * 课时及格线
     */
    private Double passClassHour;
    /**
     * 总学时
     */
    private Double classHourTotal;
    /**
     * 公司名称
     */
    private String cname;
    /**
     * 企业社会信用代码
     */
    private String creditCode;
    /**
     * 已经开始考试（0否 1是）
     */
    private Integer hasBegunTest;
    /**
     * 最早进入考试的时间
     */
    private Date examEarliestTime;
    /**
     * 重考次数限制(0-不限次数)
     */
    private Integer retestLimit;
    /**
     * 支付状态
     */
    private Integer hasPaid;
    /**
     * 同步结果状态（0未同步 1同步成功 2同步失败）
     */
    private Integer synState;
    /**
     * 同步结果描述
     */
    private String synDes;

    /**
     * 统一考试-考试状态(0-待考试；1-未通过；2-已通过)
     */
    private Integer testStatus;

    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 更新人名称
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String updateName;
    /**
     * 是否有效(0-无效；1-有效)
     */
    private Boolean isValid;


}
