package cn.smarthse.radiationTraining.modules.training.entity.enroll;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;


/**
 * <p>
 * 企业-培训报名表
 * </p>
 *
 * @author wuxq
 * @since 2022-3-18
 */
@Data
@Accessors(chain = true)
@TableName("tu_enroll")
public class TuEnroll implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * ID
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;
    /**
     * 用户id
     */
    private Long uid;
    /**
     * 培训主表id
     */
    private Long tid;
    /**
     * 导入的培训id
     */
    private String importedId;
    /**
     * 批次导入编码（代码自己生成）
     */
    private String importedBatchCode;
    /**
     * 企业ID
     */
    @Deprecated
    private Long cid;
    /**
     * 职业健康系统的企业id
     */
    private Long hseCid;
    /**
     * 报名来源（1单位 2个人）
     */
    private Integer source;
    /**
     * 企业名称
     */
    private String companyName;
    /**
     * 发证单位id
     */
    private Long issueUnitId;
    /**
     * 发证单位
     */
    private String issueUnitName;
    /**
     * 社会信用代码
     */
    private String creditCode;
    /**
     * 报名时间
     */
    private Date enrollTime;
    /**
     * 报名人数
     */
    private Integer enrollNum;
    /**
     * 已取证人数
     */
    private Integer hasCertificateNum;
    /**
     * 培训状态(0-退回；1-待培训；2-培训中；3-培训结束)
     */
    private Integer trainStatus;
    /**
     * 培训类型(0-专业；1-精准；)
     */
    private Integer trainMode;
    /**
     * 同步结果状态（0未同步 1同步成功 2同步失败）
     */
    private Integer syncState;
    /**
     * 同步结果描述
     */
    private String synDes;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 是否有效(0-无效；1-有效)
     */
    private Boolean isValid;


}
