package cn.smarthse.radiationTraining.modules.training.entity.course;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

@Data
@TableName("course_item_radiation")
@Accessors(chain = true)
public class CourseItemRadiation implements Serializable {
    /**
     * 编号
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 危害因素等级
     */
    private Integer level;
    /**
     * 危害因素类型
     */
    private String type;
    /**
     * 危害因素code
     */
    private String code;
    /**
     * 危害因素名称
     */
    private String name;
    /**
     * 后代节点数量
     */
    private Long progenyNum;
    /**
     * 课程表id
     */
    private Long courseItemId;

    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 创建时间
     */
    private Date createDate;
    /**
     * 更新时间
     */
    private Date updateDate;
    /**
     * 是否有效（0-无效，1-有效）
     */
    private Long isValid;


}
