package cn.smarthse.radiationTraining.modules.training.entity.course;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

@Data
@TableName("course_item_person_type")
@Accessors(chain = true)
public class CourseItemPersonType implements Serializable {
    /**
     * 编号
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;
    /**
     * 人员类型code
     */
    private String code;
    /**
     * 人员类型名称
     */
    private String name;

//    /**
//     *"学习类型（0 全部 -1无 1必修 2选修）
//     */
//    private Integer learningType;
//    /**
//     *"学习类型（培训类型（0 全部 -1无 1初次 2继续 ））
//     */
//    private Integer trainingType;
    /**
     * 初次教育学习类型（-1无 0全部 1必修 2选修
     */
    private Integer initialEducationType;
    /**
     * 继续教育学习类型（-1无 0全部 1必修 2选修）
     */
    private Integer continuingEducationType;
    /**
     * 课程表id
     */
    private Long courseItemId;
    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 创建时间
     */
    private Date createDate;
    /**
     * 更新时间
     */
    private Date updateDate;
    /**
     * 是否有效（0-无效，1-有效）
     */
    private Long isValid;

    public CourseItemPersonType() {
    }

    public CourseItemPersonType(String code, String name) {
        this.code = code;
        this.name = name;
    }
}
