package cn.smarthse.radiationTraining.modules.training.entity.course;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

@Data
@TableName("course_item")
@Accessors(chain = true)
public class CourseItem implements Serializable {
    /**
     * 编号
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;
    /**
     * 课程名称
     */
    private String name;
    /**
     * 讲师名称
     */
    private String lecturer;
    /**
     * 简介
     */
    private String description;
    /**
     * 封面
     */
    private Long coverId;
    /**
     * 封面
     */
    private String coverUrl;
    /**
     * 视频id
     */
    private Long videoId;
    /**
     * 视频url
     */
    private String videoUrl;

    /**
     *腾讯视频id
     */
    private String txVideoId;

    /**
     *腾讯视频url
     */
    private String txVideoUrl;
    /**
     * 试卷结构表id
     */
    private Long paperStructureId;
    /**
     * 课时数
     */
    private Double classHour;
    /**
     * 视频时长(秒)
     */
    private Long videoDurationSec;
    /**
     * 编辑人
     */
    private Long editor;
    /**
     * 编辑人
     */
    private Long owner;

    /**
     * 观看条件（0通用，1专用）枚举：CourseItemPermissionEnum
     */
    private Integer permissionType;
    /**
     * "观看条件（0专用，1通用用）枚举：CourseTypeEnum
     */
    private Integer courseType;

    /**
     * 是否是重点课程
     */
    private Integer isKeyCourse;
    /**
     * 区域id
     */
    private Long areaId;

    /**
     * 重点课程试题附件
     */
    private String keyQuestionFids;

    /**
     * 状态（0-草稿，1-启用，2-禁用）
     */
    private Long status;
    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 创建时间
     */
    private Date createDate;
    /**
     * 更新时间
     */
    private Date updateDate;
    /**
     * 是否有效（0-无效，1-有效）
     */
    private Long isValid;


}
