package cn.smarthse.radiationTraining.modules.training.entity.course;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

@Data
@TableName("course_group_item")
@Accessors(chain = true)
public class CourseGroupItem implements Serializable {
    /**
     * 编号
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;
    /**
     * 课程组表id
     */
    private Long courseGroupId;


    /**
     * 排序，序号越小越靠前
     */
    private Long sequence;
    /**
     * 课程表id
     */
    private Long courseItemId;
    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 创建时间
     */
    private Date createDate;
    /**
     * 更新时间
     */
    private Date updateDate;
    /**
     * 是否有效（0-无效，1-有效）
     */
    private Long isValid;


}
