package cn.smarthse.radiationTraining.modules.training.entity.certificate;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * @author <开发者>
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2022-05-07 02:38
 */
@Data
@TableName("tu_certificate")
public class TuCertificate implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     *
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;
    /**
     *
     */
    private Long uid;
    /**
     * 培训id
     */
    private Long tid;
    /**
     * 报名详情id
     */
    private Long enrollDetailId;
    /**
     * 导入的培训id
     */
    private String importedId;
    /**
     * 批次导入编码（代码自己生成）
     */
    private String importedBatchCode;
    /**
     * 报名来源(1-个人；2-单位; 4-导入)
     */
    private Integer enrollSource;
    /**
     * 证书名称
     */
    private String name;
    /**
     * 证书类型（即：人员类型TrainingPersonTypeEnum）
     */
    private String certType;
    /**
     * 姓名
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String uname;
    /**
     * 性别
     */
    private String sex;
    /**
     * 身份证号
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String idCard;
    /**
     * 行政区划-6位
     */
    private String areaId;
    /**
     * 年份
     */
    private Integer year;
    /**
     * 流水号
     */
    private Integer serialNo;
    /**
     * 证书编号
     */
    private String certificateNo;
    /**
     * 资格证书编号（机构培训才有）
     */
    private String qualificationCertNo;
    /**
     * 培训名称
     */
    private String trainingName;
    /**
     * 培训单位
     */
    private String trainingUnitName;
    /**
     * 用人单位
     */
    private String unitName;
    /**
     * 培训类型
     */
    private String trainType;
    /**
     * 发证日期
     */
    private Date issueTime;
    /**
     * 培训开始日期
     */
    private Date trainStarDate;
    /**
     * 培训结束日期
     */
    private Date trainEndDate;
    /**
     * 失效日期
     */
    private Date invalidDate;
    /**
     * 复审日期
     */
    private Date reviewDate;
    /**
     * 证书pdf附件id
     */
    private Long pdfFileId;
    /**
     * 证书pdf路径
     */
    private String pdfUrl;
    /**
     * 证书img路径
     */
    private String imgUrl;
    /**
     * 证书背景id(CertBgEnum为准)
     */
    private Long backgroundId;
    /**
     * 电子章图片url
     */
    private String sealUrl;
    /**
     * 同步结果状态（0未同步 1同步成功 2同步失败）
     */
    private Integer syncState;
    /**
     * 同步结果描述
     */
    private String syncDes;
    /**
     * 创建者ID
     */
    private Long createBy;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新者ID
     */
    private Long updateBy;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 是否有效（0：无效，1：有效）
     */
    private Boolean isValid;

    @TableField(exist = false)
    private String desensitizationIdCard;


}
