package cn.smarthse.radiationTraining.modules.training.entity.certificate;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;

/**
 * 放射专委会培训结果
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("ra_tu_certificate")
public class RaTuCertificate extends BaseBean implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;
    /**
     *
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 主表id
     */
    private Long tid;

    /**
     * 状态(1-草稿；2-已提交)
     */
    private Integer status;

    private Long cid;

    /**
     * 姓名
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String uname;

    /**
     * 性别
     */
    private String sex;

    /**
     * 出生日期
     */
    private Date birthday;

    /**
     * 证件类型：1-身份证；2-其他
     */
    private Integer idCardType;

    /**
     * 身份证号
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String idCard;
    @TableField(exist = false)
    private String desensitizationIdCard;

    /**
     * 证书类型（主要负责人培训证书-200001；职业卫生管理人员培训证书-200002；放射工作人员放射防护岗中培训证明-300002）
     */
    private String certType;
    @TableField(exist = false)
    private String certTypeStr;

    /**
     * 培训类型（中文存储，放射工作人员放射防护岗中培训；企业主要负责人/管理人员继续教育）
     */
    private String trainType;

    /**
     * 年份
     */
    private Integer year;

    /**
     * 行政区划-6位
     */
    private String areaId;

    /**
     * 流水号
     */
    private Integer serialNo;

    /**
     * 证书编号
     */
    private String certificateNo;

    /**
     * 培训发证单位
     */
    private String trainingUnitName;

    /**
     * 用人单位名称
     */
    private String unitName;

    /**
     * 用人单位统一社会信用代码
     */
    private String unitCreditCode;

    /**
     * 培训结果：0-不合格；1-合格
     */
    private Integer trainingResult;

    /**
     * 发证日期
     */
    private Date issueTime;

    /**
     * 失效日期
     */
    private Date invalidDate;

    /**
     * 证书pdf附件id
     */
    private Long pdfFileId;

    /**
     * 证书pdf路径
     */
    private String pdfUrl;

    /**
     * 证书img路径
     */
    private String imgUrl;

    /**
     * 证书背景id(CertBgEnum为准)
     */
    private Long backgroundId;

    /**
     * 电子章图片url
     */
    private String sealUrl;

    /**
     * 同步结果状态（0未同步 1同步成功 2同步失败）
     */
    private Integer syncState;

    /**
     * 同步结果描述
     */
    private String syncDes;

    public String getCertTypeStr() {
        if(StringUtils.isEmpty(certType))
            return "";
        switch (certType) {
            case "200001":
                certTypeStr = "主要负责人培训证书";
                break;
            case "200002":
                certTypeStr = "职业卫生管理人员培训证书";
                break;
            case "300002":
                certTypeStr = "放射工作人员放射防护岗中培训证明";
                break;
            default:
                certTypeStr = "";
        }
        return certTypeStr;
    }
}
