package cn.smarthse.radiationTraining.modules.training.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Classname TrainingImportDataDto
 * @Description 培训数据导入
 * @Date 2023/8/9 10:03
 * @Author chenliang
 */
@Data
public class TrainingImportDataDto implements Serializable {

    @ExcelProperty(index = 0)
    //@ApiModelProperty("单位id")
    public Long cid;

    @ExcelProperty(index = 1)
    //@ApiModelProperty("单位名称")
    public String unitName;

    @ExcelProperty(index = 2)
    //@ApiModelProperty("培训开始时间")
    private Date trainStarTime;

    @ExcelProperty(index = 3)
    //@ApiModelProperty("培训结束时间")
    private Date trainEndTime;

    @ExcelProperty(index = 4)
    //@ApiModelProperty("培训区域id")
    private Long trainArea;

    @ExcelProperty(index = 5)
    //@ApiModelProperty("上报时间")
    private Date reportTime;

    @ExcelProperty(index = 6)
    //@ApiModelProperty("员工姓名")
    public String userName;

    @ExcelProperty(index = 7)
    //@ApiModelProperty("员工身份证")
    public String idCard;

    @ExcelProperty(index = 8)
    //@ApiModelProperty("证书类型")
    public String certType;

    @ExcelProperty(index = 9)
    //@ApiModelProperty("证书编号")
    public String certNo;

    @ExcelProperty(index = 10)
    //@ApiModelProperty("取证日期")
    public Date issueTime;

    @ExcelProperty(index = 11)
    //@ApiModelProperty("证书有效截止日期")
    public Date invalidDate;

    @ExcelProperty(index = 12)
    //@ApiModelProperty("培训id(导入)")
    public String importedTid;

    @ExcelProperty(index = 13)
    //@ApiModelProperty("培训名称")
    public String trainingName;



    //@ApiModelProperty("用户id")
    public Long uid;

    //@ApiModelProperty("培训id")
    public Long tid;

    //@ApiModelProperty("单位报名id")
    public Long tuEnrollId;

    //@ApiModelProperty("个人报名id")
    public Long tuEnrollDetailId;

    //@ApiModelProperty("批次导入编码")
    public String importedBatchCode;
}
