package cn.smarthse.radiationTraining.modules.training.dto;

import cn.smarthse.radiationTraining.modules.training.entity.certificate.TuCertificate;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnroll;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingPersonCertificate;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 *
 * 培训信息上下文
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/9/1 9:21
 */
@Data
@Accessors(chain = true)
public class TrainingContext {

    /**
     *  职业健康在线单位cid
     */
    String token;
    /**
     *  职业健康在线单位旧cid
     */
    String oldToken;
    /**
     *  用户联系方式
     */
    String userPhone;
    /**
     *  培训基础信息
     */
    Training training;
    /**
     *  培训信息-设置
     */
    TrainingPersonCertificate personCertificate;
    /**
     *  单位报名信息
     */
    TuEnroll tuEnroll;
    /**
     *  个人报名信息
     */
    TuEnrollDetail tuEnrollDetail;
    /**
     * 个人报名的一个证书信息
     */
    TuCertificate tuCertificate;

    public Long getTrainingId() {
        return training == null ? null : training.getId();
    }

    public Long getCid() {
        return tuEnroll == null ? null : tuEnroll.getCid();
    }

    public Long getTuCertId() {
        return tuCertificate == null ? null : tuCertificate.getId();
    }

    public Long getTokenLong() {
        try {
            return Long.parseLong(token);
        } catch (NumberFormatException e) {
            return null;
        }
    }
}
