package cn.smarthse.radiationTraining.modules.training.dto;

import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;

/**
 * 放射专委会培训结果
 */
@Data
public class ImportRaTuCertDto implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 培训主表id
     */
    @ExcelIgnore
    private Long tid;
    /**
     * 状态：1-草稿；2-已提交
     */
    @ExcelIgnore
    private Integer status;

    /**
     * 姓名
     */
    @ExcelProperty(index = 1)
    private String uname;

    /**
     * 身份证明类型
     */
    @ExcelProperty(index = 2)
    private String idCardTypeStr;
    @ExcelIgnore
    private Integer idCardType;

    /**
     * 身份证号
     */
    @ExcelProperty(index = 3)
    private String idCard;

    /**
     * 出生日期
     */
    @ExcelProperty(index = 4)
    private Date birthday;

    /**
     * 性别
     */
    @ExcelProperty(index = 5)
    private String sex;

    /**
     * 用人单位ic
     */
    @ExcelIgnore
    private Long cid;

    /**
     * 所在用人单位名称
     */
    @ExcelProperty(index = 6)
    private String unitName;

    /**
     * 所在用人单位社会统一信用代码
     */
    @ExcelProperty(index = 7)
    private String unitCreditCode;

    /**
     * 证书类型（人员类型：
     * 主要负责人-200001;
     * 职业卫生管理人员-200002;
     * 放射工作人员-300002）
     */
    @ExcelProperty(index = 8)
    private String certTypeStr;
    @ExcelIgnore
    private String certType;

    /**
     * 培训类型
     */
    @ExcelProperty(index = 9)
    private String trainType;

    /**
     * 证书编号
     */
    @ExcelProperty(index = 10)
    private String certificateNo;

    /**
     * 证书发证日期
     */
    @ExcelProperty(index = 11)
    @DateTimeFormat("yyyy/M/d")
    private Date issueTime;

    /**
     * 证书失效日期
     */
    @ExcelProperty(index = 12)
    @DateTimeFormat("yyyy/M/d")
    private Date invalidDate;

    /**
     * 培训结果：0-不合格；1-合格
     */
    @ExcelProperty(index = 13)
    private String trainingResultStr;
    private Integer trainingResult;

    /**
     * 发证单位名称
     */
    @ExcelProperty(index = 14)
    private String trainingUnitName;

    public Integer getIdCardType() {
        if (StringUtils.isNotEmpty(idCardTypeStr)) {
            if (idCardTypeStr.equals("身份证")) {
                return 1;
            } else if (idCardTypeStr.equals("其他")) {
                return 2;
            } else {
                return null;
            }
        }
        return null;
    }

    public String getCertType() {
        if (StringUtils.isNotEmpty(certTypeStr)) {
            if (certTypeStr.equals("企业主要负责人培训证书")) {
                return "200001";
            }
            if (certTypeStr.equals("职业卫生管理人员培训证书")) {
                return "200002";
            }
            if (certTypeStr.equals("放射工作人员放射防护岗中培训证明")) {
                return "300002";
            }
        }
        return null;
    }

    public Integer getTrainingResult() {
        if (StringUtils.isNotEmpty(trainingResultStr)) {
            if (trainingResultStr.equals("不合格")) {
                return 0;
            } else if (trainingResultStr.equals("合格")) {
                return 1;
            } else {
                return null;
            }
        }
        return null;
    }
}
