/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.radiationTraining.modules.training.enums.GroupTrainingTartgetTypeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingPersonTypeEnum;
import cn.smarthse.radiationTraining.modules.training.utils.IndustryTypeUtils;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonTypeUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PersonTypeUtils.class);

    public static boolean checkTTTypeAndPT(String trainingTargetType, List<String> personTypeList) {
        if (StrUtil.isBlank((CharSequence)trainingTargetType) || CollUtil.isEmpty(personTypeList)) {
            return true;
        }
        HashSet<String> tttSet = new HashSet<String>();
        for (String pt : personTypeList) {
            if (StrUtil.equalsAny((CharSequence)pt, (CharSequence[])new CharSequence[]{TrainingPersonTypeEnum.MAIN_IN_CHARGE.getValue(), TrainingPersonTypeEnum.HEALTH_ADMIN.getValue(), "0"})) {
                tttSet.add(GroupTrainingTartgetTypeEnum.UNIT.getValue());
            }
            if (StrUtil.equals((CharSequence)pt, (CharSequence)TrainingPersonTypeEnum.RAY_WORK.getValue())) {
                tttSet.add(GroupTrainingTartgetTypeEnum.RAY_WORK.getValue());
            }
            if (!StrUtil.equals((CharSequence)pt, (CharSequence)TrainingPersonTypeEnum.RAY_WORK_NON_MEDICAL.getValue())) continue;
            tttSet.add(GroupTrainingTartgetTypeEnum.RAY_WORK_NON_MEDICAL.getValue());
        }
        if (StrUtil.equals((CharSequence)trainingTargetType, (CharSequence)GroupTrainingTartgetTypeEnum.UNIT.getValue())) {
            return tttSet.contains(GroupTrainingTartgetTypeEnum.UNIT.getValue());
        }
        if (StrUtil.equalsAny((CharSequence)trainingTargetType, (CharSequence[])new CharSequence[]{GroupTrainingTartgetTypeEnum.RAY_WORK.getValue(), GroupTrainingTartgetTypeEnum.RAY_WORK_NON_MEDICAL.getValue()})) {
            return personTypeList.contains(trainingTargetType);
        }
        return true;
    }

    public static boolean checkPtAndIndustry(List<String> personTypeList, List<String> industryCodeList) {
        boolean containUnitPT = personTypeList.contains(TrainingPersonTypeEnum.UNIT.getValue()) || personTypeList.contains(TrainingPersonTypeEnum.MAIN_IN_CHARGE.getValue()) || personTypeList.contains(TrainingPersonTypeEnum.HEALTH_ADMIN.getValue());
        boolean containMedicalPT = personTypeList.contains(TrainingPersonTypeEnum.RAY_WORK.getValue());
        boolean containNonMedicalPT = personTypeList.contains(TrainingPersonTypeEnum.RAY_WORK_NON_MEDICAL.getValue());
        boolean containMedicalIndustry = IndustryTypeUtils.containMedicalIndustry(industryCodeList);
        boolean containNonMedicalIndustry = IndustryTypeUtils.containNonMedicalIndustry(industryCodeList);
        int pType = containMedicalPT && containNonMedicalPT ? 3 : (containMedicalPT && !containNonMedicalPT ? 1 : (!containMedicalPT && containNonMedicalPT ? 2 : 0));
        boolean flag = true;
        if (!containUnitPT) {
            if (pType == 0) {
                flag = true;
            }
            if (pType == 1) {
                boolean bl = flag = containMedicalIndustry && !containNonMedicalIndustry;
            }
            if (pType == 2) {
                boolean bl = flag = !containMedicalIndustry && containNonMedicalIndustry;
            }
            if (pType == 3) {
                flag = containMedicalIndustry && containNonMedicalIndustry;
            }
        } else {
            if (pType == 0) {
                flag = true;
            }
            if (pType == 1) {
                flag = containMedicalIndustry;
            }
            if (pType == 2) {
                flag = containNonMedicalIndustry;
            }
            if (pType == 3) {
                flag = containMedicalIndustry && containNonMedicalIndustry;
            }
        }
        return flag;
    }
}

