package cn.smarthse.radiationTraining.modules.wqxx.provider.articleVideo;


import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.wqxx.entity.SArticleVideo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.articleVideo.ArticleVideoListVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.articleVideo.ArticleVideoVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.articleVideo.EarnIntegralVo;
import cn.smarthse.radiationTraining.modules.wqxx.param.articleVideoStudy.ArticleListForUserSearchParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.articleVideoStudy.EarnIntegralParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SArticle.SArticleVideoBatchAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SArticle.SArticleVideoEditAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SArticle.SArticleVideoListAdminParam;

/**
 * IArticleVideoProviderService
 * 暴露接口
 * @author chuhy
 * @Date 2023/8/31
 */
public interface IArticleVideoProviderService {

    /**
     * @description: 添加视频文章课程
     * @author: chenliang
     * @date: 2023/8/28 14:05
     * @param param
     * @return: {@link SArticleVideo}
     */
    SArticleVideo addForAdmin(SArticleVideoEditAdminParam param);

    /**
     * @description:
     * @author: chenliang
     * @date: 2023/8/28 14:20
     * @param param
     * @return: {@link SArticleVideo}
     */
    SArticleVideo editForAdmin(SArticleVideoEditAdminParam param);

    /**
     * @description: 删除
     * @author: chenliang
     * @date: 2023/9/11 10:30
     * @param param
     */
    void delBatchForAdmin(SArticleVideoBatchAdminParam param);

    /**
     * @description: 文章视频上下架
     * @author: chenliang
     * @date: 2023/9/11 11:00
     * @param param
     * @return:
     */
    void upOrDownBatchForAdmin(SArticleVideoBatchAdminParam param);

    /**
     * @description:
     * @author: 文章视频列表
     * @date: 2023/9/11 11:08
     * @param param
     * @return: {@link LayuiGridData<ArticleVideoVo>}
     */
    LayuiGridData<ArticleVideoVo> listForAdmin(SArticleVideoListAdminParam param);

    /**
     * @description: 查看详情
     * @author: chenliang
     * @date: 2023/9/11 11:29
     * @param id
     * @return: {@link ArticleVideoVo}
     */
    ArticleVideoVo getDetailForAdmin(Long id);

    /**
     * 移动端-文图学习列表
     * @param param
     * @return {@link LayuiGridData< ArticleVideoListVo>}
     * @author chuhy
     * @date 2023/9/1 14:39
     */
    LayuiGridData<ArticleVideoListVo> listArticleVideoForUser(ArticleListForUserSearchParam param);

    /**
     * 移动端-文章视频-详情
     * @param param
     * @return {@link ArticleVideoVo}
     * @author chuhy
     * @date 2023/9/1 14:39
     */
    ArticleVideoVo getArticleVideoDetailForUser(ArticleListForUserSearchParam param);


    /**
     * 学习(文章/视频)-添加积分
     * tips:老的接口，需求有改动，不用了
     * @param param
     * @return {@link EarnIntegralVo}
     * @author chuhy
     * @date 2023/9/15 9:12
     */
    @Deprecated
    EarnIntegralVo earnIntegralFromArticleVideoOld(EarnIntegralParam param);

    /**
     * 文章/视频-添加积分(每周只加一次分)
     * @param param
     * @return {@link EarnIntegralVo}
     * @author chuhy
     * @date 2023/9/15 9:12
     */
    EarnIntegralVo earnIntegralFromArticleVideo(EarnIntegralParam param);
}
